"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuantizedMeshLoader = exports.QuantizedMeshWorkerLoader = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _parseQuantizedMesh = _interopRequireDefault(require("./lib/parse-quantized-mesh"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';
var QuantizedMeshWorkerLoader = {
  id: 'quantized-mesh',
  name: 'Quantized Mesh',
  version: VERSION,
  extensions: ['terrain'],
  mimeTypes: ['application/vnd.quantized-mesh'],
  options: {
    'quantized-mesh': {
      workerUrl: "https://unpkg.com/@loaders.gl/terrain@".concat(VERSION, "/dist/quantized-mesh-loader.worker.js"),
      bounds: [0, 0, 1, 1]
    }
  }
};
exports.QuantizedMeshWorkerLoader = QuantizedMeshWorkerLoader;

var QuantizedMeshLoader = _objectSpread(_objectSpread({}, QuantizedMeshWorkerLoader), {}, {
  parseSync: _parseQuantizedMesh["default"],
  parse: function () {
    var _parse = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(arrayBuffer, options) {
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              return _context.abrupt("return", (0, _parseQuantizedMesh["default"])(arrayBuffer, options));

            case 1:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function parse(_x, _x2) {
      return _parse.apply(this, arguments);
    }

    return parse;
  }()
});

exports.QuantizedMeshLoader = QuantizedMeshLoader;
//# sourceMappingURL=quantized-mesh-loader.js.map