import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import loadTerrain from './lib/parse-terrain';
var VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';
export var TerrainWorkerLoader = {
  id: 'terrain',
  name: 'Terrain',
  version: VERSION,
  extensions: ['png', 'pngraw'],
  mimeTypes: ['image/png'],
  options: {
    terrain: {
      bounds: null,
      workerUrl: "https://unpkg.com/@loaders.gl/terrain@".concat(VERSION, "/dist/terrain-loader.worker.js"),
      meshMaxError: 10,
      elevationDecoder: {
        rScaler: 1,
        gScaler: 0,
        bScaler: 0,
        offset: 0
      }
    }
  }
};
export var TerrainLoader = _objectSpread(_objectSpread({}, TerrainWorkerLoader), {}, {
  parse: loadTerrain
});
//# sourceMappingURL=terrain-loader.js.map