"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _doublyLinkedList = _interopRequireDefault(require("../utils/doubly-linked-list"));

function defined(x) {
  return x !== undefined && x !== null;
}

var TilesetCache = function () {
  function TilesetCache() {
    (0, _classCallCheck2["default"])(this, TilesetCache);
    this._list = new _doublyLinkedList["default"]();
    this._sentinel = this._list.add('sentinel');
    this._trimTiles = false;
  }

  (0, _createClass2["default"])(TilesetCache, [{
    key: "reset",
    value: function reset() {
      this._list.splice(this._list.tail, this._sentinel);
    }
  }, {
    key: "touch",
    value: function touch(tile) {
      var node = tile._cacheNode;

      if (defined(node)) {
        this._list.splice(this._sentinel, node);
      }
    }
  }, {
    key: "add",
    value: function add(tileset, tile, addCallback) {
      if (!defined(tile._cacheNode)) {
        tile._cacheNode = this._list.add(tile);

        if (addCallback) {
          addCallback(tileset, tile);
        }
      }
    }
  }, {
    key: "unloadTile",
    value: function unloadTile(tileset, tile, unloadCallback) {
      var node = tile._cacheNode;

      if (!defined(node)) {
        return;
      }

      this._list.remove(node);

      tile._cacheNode = undefined;

      if (unloadCallback) {
        unloadCallback(tileset, tile);
      }
    }
  }, {
    key: "unloadTiles",
    value: function unloadTiles(tileset, unloadCallback) {
      var trimTiles = this._trimTiles;
      this._trimTiles = false;
      var list = this._list;
      var maximumMemoryUsageInBytes = tileset.maximumMemoryUsage * 1024 * 1024;
      var sentinel = this._sentinel;
      var node = list.head;

      while (node !== sentinel && (tileset.gpuMemoryUsageInBytes > maximumMemoryUsageInBytes || trimTiles)) {
        var tile = node.item;
        node = node.next;
        this.unloadTile(tileset, tile, unloadCallback);
      }
    }
  }, {
    key: "trim",
    value: function trim() {
      this._trimTiles = true;
    }
  }]);
  return TilesetCache;
}();

exports["default"] = TilesetCache;
//# sourceMappingURL=tileset-cache.js.map