import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { load } from '@loaders.gl/core';
import TilesetTraverser from './tileset-traverser';
import { lodJudge } from '../helpers/i3s-lod';
import TileHeader from '../tile-3d';
import I3STileManager from './i3s-tile-manager';
export default class I3STilesetTraverser extends TilesetTraverser {
  constructor(options) {
    super(options);
    this._tileManager = new I3STileManager();
  }

  shouldRefine(tile, frameState) {
    tile._lodJudge = lodJudge(tile, frameState);
    return tile._lodJudge === 'DIG';
  }

  updateChildTiles(tile, frameState) {
    const children = tile.header.children || [];
    const childTiles = tile.children;
    const tileset = tile.tileset;

    for (const child of children) {
      const childTile = childTiles && childTiles.find(t => t.id === child.id);

      if (!childTile) {
        const request = () => this._loadTile(child.id, tileset);

        const cachedRequest = this._tileManager.find(child.id);

        if (!cachedRequest) {
          this._tileManager.add(request, child.id, header => this._onTileLoad(header, tile), frameState);
        } else {
          this._tileManager.update(child.id, frameState);
        }
      } else if (childTile) {
        this.updateTile(childTile, frameState);
      }
    }
  }

  async _loadTile(nodeId, tileset) {
    const {
      loader
    } = tileset;
    const nodeUrl = tileset.getTileUrl("".concat(tileset.url, "/nodes/").concat(nodeId));
    const options = {
      i3s: _objectSpread(_objectSpread({}, tileset.fetchOptions), {}, {
        isHeader: true,
        loadContent: false
      })
    };
    return await load(nodeUrl, loader, options);
  }

  _onTileLoad(header, tile) {
    const basePath = this.options.basePath;
    const childTile = new TileHeader(tile.tileset, header, tile, basePath);
    tile.children.push(childTile);

    const frameState = this._tileManager.find(childTile.id).frameState;

    this.updateTile(childTile, frameState);

    if (this._frameNumber === frameState.frameNumber) {
      this.executeTraversal(childTile, frameState);
    }
  }

}
//# sourceMappingURL=i3s-tilset-traverser.js.map