import { Matrix4, Vector3, clamp } from '@math.gl/core';
var scratchPositionNormal = new Vector3();
var scratchCartographic = new Vector3();
var scratchMatrix = new Matrix4();
var scratchCenter = new Vector3();
var scratchPosition = new Vector3();
var scratchDirection = new Vector3();
export function calculateDynamicScreenSpaceError(root, _ref) {
  var camera = _ref.camera,
      mapProjection = _ref.mapProjection;
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var _options$dynamicScree = options.dynamicScreenSpaceErrorHeightFalloff,
      dynamicScreenSpaceErrorHeightFalloff = _options$dynamicScree === void 0 ? 0.25 : _options$dynamicScree,
      _options$dynamicScree2 = options.dynamicScreenSpaceErrorDensity,
      dynamicScreenSpaceErrorDensity = _options$dynamicScree2 === void 0 ? 0.00278 : _options$dynamicScree2;
  var up;
  var direction;
  var height;
  var minimumHeight;
  var maximumHeight;
  var tileBoundingVolume = root.contentBoundingVolume;

  if (tileBoundingVolume instanceof TileBoundingRegion) {
    up = Cartesian3.normalize(camera.positionWC, scratchPositionNormal);
    direction = camera.directionWC;
    height = camera.positionCartographic.height;
    minimumHeight = tileBoundingVolume.minimumHeight;
    maximumHeight = tileBoundingVolume.maximumHeight;
  } else {
    var transformLocal = Matrix4.inverseTransformation(root.computedTransform, scratchMatrix);
    var ellipsoid = mapProjection.ellipsoid;
    var boundingVolume = tileBoundingVolume.boundingVolume;
    var centerLocal = Matrix4.multiplyByPoint(transformLocal, boundingVolume.center, scratchCenter);

    if (Cartesian3.magnitude(centerLocal) > ellipsoid.minimumRadius) {
      var centerCartographic = Cartographic.fromCartesian(centerLocal, ellipsoid, scratchCartographic);
      up = Cartesian3.normalize(camera.positionWC, scratchPositionNormal);
      direction = camera.directionWC;
      height = camera.positionCartographic.height;
      minimumHeight = 0.0;
      maximumHeight = centerCartographic.height * 2.0;
    } else {
      var positionLocal = Matrix4.multiplyByPoint(transformLocal, camera.positionWC, scratchPosition);
      up = Cartesian3.UNIT_Z;
      direction = Matrix4.multiplyByPointAsVector(transformLocal, camera.directionWC, scratchDirection);
      direction = Cartesian3.normalize(direction, direction);
      height = positionLocal.z;

      if (tileBoundingVolume instanceof TileOrientedBoundingBox) {
        var boxHeight = root._header.boundingVolume.box[11];
        minimumHeight = centerLocal.z - boxHeight;
        maximumHeight = centerLocal.z + boxHeight;
      } else if (tileBoundingVolume instanceof TileBoundingSphere) {
        var radius = boundingVolume.radius;
        minimumHeight = centerLocal.z - radius;
        maximumHeight = centerLocal.z + radius;
      }
    }
  }

  var heightFalloff = dynamicScreenSpaceErrorHeightFalloff;
  var heightClose = minimumHeight + (maximumHeight - minimumHeight) * heightFalloff;
  var heightFar = maximumHeight;
  var t = clamp((height - heightClose) / (heightFar - heightClose), 0.0, 1.0);
  var dot = Math.abs(Cartesian3.dot(direction, up));
  var horizonFactor = 1.0 - dot;
  horizonFactor = horizonFactor * (1.0 - t);
  return dynamicScreenSpaceErrorDensity * horizonFactor;
}
export function fog(distanceToCamera, density) {
  var scalar = distanceToCamera * density;
  return 1.0 - Math.exp(-(scalar * scalar));
}
export function getDynamicScreenSpaceError(tileset, distanceToCamera) {
  if (tileset.dynamicScreenSpaceError && tileset._dynamicScreenSpaceErrorComputedDensity) {
    var density = tileset._dynamicScreenSpaceErrorComputedDensity;
    var factor = tileset.dynamicScreenSpaceErrorFactor;
    var dynamicError = fog(distanceToCamera, density) * factor;
    return dynamicError;
  }

  return 0;
}
export function getTiles3DScreenSpaceError(tile, frameState, useParentLodMetric) {
  var tileset = tile.tileset;
  var parentLodMetricValue = tile.parent && tile.parent.lodMetricValue || tile.lodMetricValue;
  var lodMetricValue = useParentLodMetric ? parentLodMetricValue : tile.lodMetricValue;

  if (lodMetricValue === 0.0) {
    return 0.0;
  }

  var distance = Math.max(tile._distanceToCamera, 1e-7);
  var height = frameState.height,
      sseDenominator = frameState.sseDenominator;
  var error = lodMetricValue * height / (distance * sseDenominator);
  error -= getDynamicScreenSpaceError(tileset, distance);
  return error;
}
//# sourceMappingURL=tiles-3d-lod.js.map