import { Ellipsoid } from '@math.gl/geospatial';
import { Matrix4, Vector3 } from '@math.gl/core';
import { assert } from '@loaders.gl/loader-utils';
export function calculateTransformProps(tileHeader, tile) {
  assert(tileHeader);
  assert(tile);
  var rtcCenter = tile.rtcCenter,
      rotateYtoZ = tile.rotateYtoZ;
  var computedTransform = tileHeader.computedTransform,
      center = tileHeader.boundingVolume.center;
  var modelMatrix = new Matrix4(computedTransform);

  if (rtcCenter) {
    modelMatrix.translate(rtcCenter);
  }

  if (rotateYtoZ) {
    var rotation = new Matrix4().rotateX(Math.PI / 2);
    modelMatrix = modelMatrix.multiplyRight(rotation);
  }

  if (tile.isQuantized) {
    modelMatrix.translate(tile.quantizedVolumeOffset).scale(tile.quantizedVolumeScale);
  }

  var cartesianOrigin = new Vector3(center);
  tile.cartesianModelMatrix = modelMatrix;
  tile.cartesianOrigin = cartesianOrigin;
  var cartographicOrigin = Ellipsoid.WGS84.cartesianToCartographic(cartesianOrigin, new Vector3());
  var fromFixedFrameMatrix = Ellipsoid.WGS84.eastNorthUpToFixedFrame(cartesianOrigin);
  var toFixedFrameMatrix = fromFixedFrameMatrix.invert();
  tile.cartographicModelMatrix = toFixedFrameMatrix.multiplyRight(modelMatrix);
  tile.cartographicOrigin = cartographicOrigin;
  tile.modelMatrix = tile.cartographicModelMatrix;
}
//# sourceMappingURL=transform-utils.js.map