import _regeneratorRuntime from "@babel/runtime/regenerator";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import { load } from '@loaders.gl/core';
import TilesetTraverser from './tileset-traverser';
import { lodJudge } from '../helpers/i3s-lod';
import TileHeader from '../tile-3d';
import I3STileManager from './i3s-tile-manager';

var I3STilesetTraverser = function (_TilesetTraverser) {
  _inherits(I3STilesetTraverser, _TilesetTraverser);

  var _super = _createSuper(I3STilesetTraverser);

  function I3STilesetTraverser(options) {
    var _this;

    _classCallCheck(this, I3STilesetTraverser);

    _this = _super.call(this, options);
    _this._tileManager = new I3STileManager();
    return _this;
  }

  _createClass(I3STilesetTraverser, [{
    key: "shouldRefine",
    value: function shouldRefine(tile, frameState) {
      tile._lodJudge = lodJudge(tile, frameState);
      return tile._lodJudge === 'DIG';
    }
  }, {
    key: "updateChildTiles",
    value: function updateChildTiles(tile, frameState) {
      var _this2 = this;

      var children = tile.header.children || [];
      var childTiles = tile.children;
      var tileset = tile.tileset;

      var _iterator = _createForOfIteratorHelper(children),
          _step;

      try {
        var _loop = function _loop() {
          var child = _step.value;
          var childTile = childTiles && childTiles.find(function (t) {
            return t.id === child.id;
          });

          if (!childTile) {
            var request = function request() {
              return _this2._loadTile(child.id, tileset);
            };

            var cachedRequest = _this2._tileManager.find(child.id);

            if (!cachedRequest) {
              _this2._tileManager.add(request, child.id, function (header) {
                return _this2._onTileLoad(header, tile);
              }, frameState);
            } else {
              _this2._tileManager.update(child.id, frameState);
            }
          } else if (childTile) {
            _this2.updateTile(childTile, frameState);
          }
        };

        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          _loop();
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }, {
    key: "_loadTile",
    value: function () {
      var _loadTile2 = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(nodeId, tileset) {
        var loader, nodeUrl, options;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                loader = tileset.loader;
                nodeUrl = tileset.getTileUrl("".concat(tileset.url, "/nodes/").concat(nodeId));
                options = {
                  i3s: _objectSpread(_objectSpread({}, tileset.fetchOptions), {}, {
                    isHeader: true,
                    loadContent: false
                  })
                };
                _context.next = 5;
                return load(nodeUrl, loader, options);

              case 5:
                return _context.abrupt("return", _context.sent);

              case 6:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function _loadTile(_x, _x2) {
        return _loadTile2.apply(this, arguments);
      }

      return _loadTile;
    }()
  }, {
    key: "_onTileLoad",
    value: function _onTileLoad(header, tile) {
      var basePath = this.options.basePath;
      var childTile = new TileHeader(tile.tileset, header, tile, basePath);
      tile.children.push(childTile);

      var frameState = this._tileManager.find(childTile.id).frameState;

      this.updateTile(childTile, frameState);

      if (this._frameNumber === frameState.frameNumber) {
        this.executeTraversal(childTile, frameState);
      }
    }
  }]);

  return I3STilesetTraverser;
}(TilesetTraverser);

export { I3STilesetTraverser as default };
//# sourceMappingURL=i3s-tilset-traverser.js.map