import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import { TILE3D_OPTIMIZATION_HINT, TILE_REFINEMENT } from '../../constants';
import TilesetTraverser from './tileset-traverser';

var Tileset3DTraverser = function (_TilesetTraverser) {
  _inherits(Tileset3DTraverser, _TilesetTraverser);

  var _super = _createSuper(Tileset3DTraverser);

  function Tileset3DTraverser() {
    _classCallCheck(this, Tileset3DTraverser);

    return _super.apply(this, arguments);
  }

  _createClass(Tileset3DTraverser, [{
    key: "compareDistanceToCamera",
    value: function compareDistanceToCamera(a, b) {
      return b._distanceToCamera === 0 && a._distanceToCamera === 0 ? b._centerZDepth - a._centerZDepth : b._distanceToCamera - a._distanceToCamera;
    }
  }, {
    key: "updateTileVisibility",
    value: function updateTileVisibility(tile, frameState) {
      tile.updateVisibility(frameState);

      if (!tile.isVisibleAndInRequestVolume) {
        return;
      }

      var hasChildren = tile.children.length > 0;

      if (tile.hasTilesetContent && hasChildren) {
        var firstChild = tile.children[0];
        this.updateTileVisibility(firstChild, frameState);
        tile._visible = firstChild._visible;
        return;
      }

      if (this.meetsScreenSpaceErrorEarly(tile, frameState)) {
        tile._visible = false;
        return;
      }

      var replace = tile.refine === TILE_REFINEMENT.REPLACE;
      var useOptimization = tile._optimChildrenWithinParent === TILE3D_OPTIMIZATION_HINT.USE_OPTIMIZATION;

      if (replace && useOptimization && hasChildren) {
        if (!this.anyChildrenVisible(tile, frameState)) {
          tile._visible = false;
          return;
        }
      }
    }
  }, {
    key: "meetsScreenSpaceErrorEarly",
    value: function meetsScreenSpaceErrorEarly(tile, frameState) {
      var parent = tile.parent;

      if (!parent || parent.hasTilesetContent || parent.refine !== TILE_REFINEMENT.ADD) {
        return false;
      }

      return !this.shouldRefine(tile, frameState, true);
    }
  }]);

  return Tileset3DTraverser;
}(TilesetTraverser);

export { Tileset3DTraverser as default };
//# sourceMappingURL=tileset-3d-traverser.js.map