import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import DoublyLinkedListNode from '../utils/doubly-linked-list-node';

var DoublyLinkedList = function () {
  function DoublyLinkedList() {
    _classCallCheck(this, DoublyLinkedList);

    this.head = null;
    this.tail = null;
    this._length = 0;
  }

  _createClass(DoublyLinkedList, [{
    key: "add",
    value: function add(item) {
      var node = new DoublyLinkedListNode(item, this.tail, null);

      if (this.tail) {
        this.tail.next = node;
        this.tail = node;
      } else {
        this.head = node;
        this.tail = node;
      }

      ++this._length;
      return node;
    }
  }, {
    key: "remove",
    value: function remove(node) {
      if (!node) {
        return;
      }

      if (node.previous && node.next) {
        node.previous.next = node.next;
        node.next.previous = node.previous;
      } else if (node.previous) {
        node.previous.next = null;
        this.tail = node.previous;
      } else if (node.next) {
        node.next.previous = null;
        this.head = node.next;
      } else {
        this.head = null;
        this.tail = null;
      }

      node.next = null;
      node.previous = null;
      --this._length;
    }
  }, {
    key: "splice",
    value: function splice(node, nextNode) {
      if (node === nextNode) {
        return;
      }

      this.remove(nextNode);

      this._insert(node, nextNode);
    }
  }, {
    key: "_insert",
    value: function _insert(node, nextNode) {
      var oldNodeNext = node.next;
      node.next = nextNode;

      if (this.tail === node) {
        this.tail = nextNode;
      } else {
        oldNodeNext.previous = nextNode;
      }

      nextNode.next = oldNodeNext;
      nextNode.previous = node;
      ++this._length;
    }
  }, {
    key: "length",
    get: function get() {
      return this._length;
    }
  }]);

  return DoublyLinkedList;
}();

export { DoublyLinkedList as default };
//# sourceMappingURL=doubly-linked-list.js.map