"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFrameState = getFrameState;

var _core = require("@math.gl/core");

var _culling = require("@math.gl/culling");

var _geospatial = require("@math.gl/geospatial");

var scratchVector = new _core.Vector3();
var scratchPosition = new _core.Vector3();
var cullingVolume = new _culling.CullingVolume([new _culling.Plane(), new _culling.Plane(), new _culling.Plane(), new _culling.Plane(), new _culling.Plane(), new _culling.Plane()]);

function getFrameState(viewport, frameNumber) {
  var cameraDirection = viewport.cameraDirection,
      cameraUp = viewport.cameraUp,
      height = viewport.height;
  var metersPerUnit = viewport.distanceScales.metersPerUnit;
  var viewportCenterCartographic = [viewport.longitude, viewport.latitude, 0];

  var viewportCenterCartesian = _geospatial.Ellipsoid.WGS84.cartographicToCartesian(viewportCenterCartographic, new _core.Vector3());

  var enuToFixedTransform = _geospatial.Ellipsoid.WGS84.eastNorthUpToFixedFrame(viewportCenterCartesian);

  var cameraPositionCartographic = viewport.unprojectPosition(viewport.cameraPosition);

  var cameraPositionCartesian = _geospatial.Ellipsoid.WGS84.cartographicToCartesian(cameraPositionCartographic, new _core.Vector3());

  var cameraDirectionCartesian = new _core.Vector3(enuToFixedTransform.transformAsVector(new _core.Vector3(cameraDirection).scale(metersPerUnit))).normalize();
  var cameraUpCartesian = new _core.Vector3(enuToFixedTransform.transformAsVector(new _core.Vector3(cameraUp).scale(metersPerUnit))).normalize();
  commonSpacePlanesToWGS84(viewport, viewportCenterCartesian);
  return {
    camera: {
      position: cameraPositionCartesian,
      direction: cameraDirectionCartesian,
      up: cameraUpCartesian
    },
    viewport: viewport,
    height: height,
    cullingVolume: cullingVolume,
    frameNumber: frameNumber,
    sseDenominator: 1.15
  };
}

function commonSpacePlanesToWGS84(viewport, viewportCenterCartesian) {
  var frustumPlanes = viewport.getFrustumPlanes();
  var i = 0;

  for (var dir in frustumPlanes) {
    var plane = frustumPlanes[dir];
    var distanceToCenter = plane.normal.dot(viewport.center);
    scratchPosition.copy(plane.normal).scale(plane.distance - distanceToCenter).add(viewport.center);
    var cartographicPos = viewport.unprojectPosition(scratchPosition);

    var cartesianPos = _geospatial.Ellipsoid.WGS84.cartographicToCartesian(cartographicPos, new _core.Vector3());

    cullingVolume.planes[i++].fromPointNormal(cartesianPos, scratchVector.copy(viewportCenterCartesian).subtract(cartesianPos));
  }
}
//# sourceMappingURL=frame-state.js.map