"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getZoomFromBoundingVolume = getZoomFromBoundingVolume;

var _core = require("@math.gl/core");

var WGS84_RADIUS_X = 6378137.0;
var WGS84_RADIUS_Y = 6378137.0;
var WGS84_RADIUS_Z = 6356752.3142451793;
var scratchVector = new _core.Vector3();

function getZoomFromBoundingVolume(boundingVolume) {
  var halfAxes = boundingVolume.halfAxes,
      radius = boundingVolume.radius,
      width = boundingVolume.width,
      height = boundingVolume.height;

  if (halfAxes) {
    halfAxes.getColumn(0, scratchVector);
    var x = scratchVector.len();
    halfAxes.getColumn(1, scratchVector);
    var y = scratchVector.len();
    halfAxes.getColumn(2, scratchVector);
    var z = scratchVector.len();
    var halfX = x / 2;
    var halfY = y / 2;
    var halfZ = z / 2;
    var zoomX = Math.log2(WGS84_RADIUS_X / halfX);
    var zoomY = Math.log2(WGS84_RADIUS_Y / halfY);
    var zoomZ = Math.log2(WGS84_RADIUS_Z / halfZ);
    return (zoomX + zoomY + zoomZ) / 3;
  } else if (radius) {
    return Math.log2(WGS84_RADIUS_Z / radius);
  } else if (height && width) {
    var _zoomX = Math.log2(WGS84_RADIUS_X / width);

    var _zoomY = Math.log2(WGS84_RADIUS_Y / height);

    return (_zoomX + _zoomY) / 2;
  }

  return 1;
}
//# sourceMappingURL=zoom.js.map