"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var STATUS = {
  REQUESTED: 'REQUESTED',
  COMPLETED: 'COMPLETED',
  ERROR: 'ERROR'
};

var I3STileManager = function () {
  function I3STileManager() {
    (0, _classCallCheck2["default"])(this, I3STileManager);
    this._statusMap = {};
  }

  (0, _createClass2["default"])(I3STileManager, [{
    key: "add",
    value: function add(request, key, callback, frameState) {
      var _this = this;

      if (!this._statusMap[key]) {
        this._statusMap[key] = {
          request: request,
          callback: callback,
          key: key,
          frameState: frameState,
          status: STATUS.REQUESTED
        };
        request().then(function (data) {
          _this._statusMap[key].status = STATUS.COMPLETED;

          _this._statusMap[key].callback(data, frameState);
        })["catch"](function (error) {
          _this._statusMap[key].status = STATUS.ERROR;
          callback(error);
        });
      }
    }
  }, {
    key: "update",
    value: function update(key, frameState) {
      if (this._statusMap[key]) {
        this._statusMap[key].frameState = frameState;
      }
    }
  }, {
    key: "find",
    value: function find(key) {
      return this._statusMap[key];
    }
  }]);
  return I3STileManager;
}();

exports["default"] = I3STileManager;
//# sourceMappingURL=i3s-tile-manager.js.map