import { Vector3 } from '@math.gl/core';
import { CullingVolume, Plane } from '@math.gl/culling';
import { Ellipsoid } from '@math.gl/geospatial';
const scratchVector = new Vector3();
const scratchPosition = new Vector3();
const cullingVolume = new CullingVolume([new Plane(), new Plane(), new Plane(), new Plane(), new Plane(), new Plane()]);
export function getFrameState(viewport, frameNumber) {
  const {
    cameraDirection,
    cameraUp,
    height
  } = viewport;
  const {
    metersPerUnit
  } = viewport.distanceScales;
  const viewportCenterCartographic = [viewport.longitude, viewport.latitude, 0];
  const viewportCenterCartesian = Ellipsoid.WGS84.cartographicToCartesian(viewportCenterCartographic, new Vector3());
  const enuToFixedTransform = Ellipsoid.WGS84.eastNorthUpToFixedFrame(viewportCenterCartesian);
  const cameraPositionCartographic = viewport.unprojectPosition(viewport.cameraPosition);
  const cameraPositionCartesian = Ellipsoid.WGS84.cartographicToCartesian(cameraPositionCartographic, new Vector3());
  const cameraDirectionCartesian = new Vector3(enuToFixedTransform.transformAsVector(new Vector3(cameraDirection).scale(metersPerUnit))).normalize();
  const cameraUpCartesian = new Vector3(enuToFixedTransform.transformAsVector(new Vector3(cameraUp).scale(metersPerUnit))).normalize();
  commonSpacePlanesToWGS84(viewport, viewportCenterCartesian);
  return {
    camera: {
      position: cameraPositionCartesian,
      direction: cameraDirectionCartesian,
      up: cameraUpCartesian
    },
    viewport,
    height,
    cullingVolume,
    frameNumber,
    sseDenominator: 1.15
  };
}

function commonSpacePlanesToWGS84(viewport, viewportCenterCartesian) {
  const frustumPlanes = viewport.getFrustumPlanes();
  let i = 0;

  for (const dir in frustumPlanes) {
    const plane = frustumPlanes[dir];
    const distanceToCenter = plane.normal.dot(viewport.center);
    scratchPosition.copy(plane.normal).scale(plane.distance - distanceToCenter).add(viewport.center);
    const cartographicPos = viewport.unprojectPosition(scratchPosition);
    const cartesianPos = Ellipsoid.WGS84.cartographicToCartesian(cartographicPos, new Vector3());
    cullingVolume.planes[i++].fromPointNormal(cartesianPos, scratchVector.copy(viewportCenterCartesian).subtract(cartesianPos));
  }
}
//# sourceMappingURL=frame-state.js.map