import { Vector3 } from '@math.gl/core';
import { CullingVolume, Plane } from '@math.gl/culling';
import { Ellipsoid } from '@math.gl/geospatial';
var scratchVector = new Vector3();
var scratchPosition = new Vector3();
var cullingVolume = new CullingVolume([new Plane(), new Plane(), new Plane(), new Plane(), new Plane(), new Plane()]);
export function getFrameState(viewport, frameNumber) {
  var cameraDirection = viewport.cameraDirection,
      cameraUp = viewport.cameraUp,
      height = viewport.height;
  var metersPerUnit = viewport.distanceScales.metersPerUnit;
  var viewportCenterCartographic = [viewport.longitude, viewport.latitude, 0];
  var viewportCenterCartesian = Ellipsoid.WGS84.cartographicToCartesian(viewportCenterCartographic, new Vector3());
  var enuToFixedTransform = Ellipsoid.WGS84.eastNorthUpToFixedFrame(viewportCenterCartesian);
  var cameraPositionCartographic = viewport.unprojectPosition(viewport.cameraPosition);
  var cameraPositionCartesian = Ellipsoid.WGS84.cartographicToCartesian(cameraPositionCartographic, new Vector3());
  var cameraDirectionCartesian = new Vector3(enuToFixedTransform.transformAsVector(new Vector3(cameraDirection).scale(metersPerUnit))).normalize();
  var cameraUpCartesian = new Vector3(enuToFixedTransform.transformAsVector(new Vector3(cameraUp).scale(metersPerUnit))).normalize();
  commonSpacePlanesToWGS84(viewport, viewportCenterCartesian);
  return {
    camera: {
      position: cameraPositionCartesian,
      direction: cameraDirectionCartesian,
      up: cameraUpCartesian
    },
    viewport: viewport,
    height: height,
    cullingVolume: cullingVolume,
    frameNumber: frameNumber,
    sseDenominator: 1.15
  };
}

function commonSpacePlanesToWGS84(viewport, viewportCenterCartesian) {
  var frustumPlanes = viewport.getFrustumPlanes();
  var i = 0;

  for (var dir in frustumPlanes) {
    var plane = frustumPlanes[dir];
    var distanceToCenter = plane.normal.dot(viewport.center);
    scratchPosition.copy(plane.normal).scale(plane.distance - distanceToCenter).add(viewport.center);
    var cartographicPos = viewport.unprojectPosition(scratchPosition);
    var cartesianPos = Ellipsoid.WGS84.cartographicToCartesian(cartographicPos, new Vector3());
    cullingVolume.planes[i++].fromPointNormal(cartesianPos, scratchVector.copy(viewportCenterCartesian).subtract(cartesianPos));
  }
}
//# sourceMappingURL=frame-state.js.map