import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { toRadians } from '@math.gl/core';
var WGS84_RADIUS_X = 6378137.0;
var qualityFactor = Math.PI / 2;
export function lodJudge(tile, frameState) {
  var viewport = frameState.viewport;
  var metersPerPixel = viewport.metersPerPixel;
  var mbsLat = tile.header.mbs[1];
  var mbsLon = tile.header.mbs[0];
  var mbsZ = tile.header.mbs[2];
  var mbsR = tile.header.mbs[3];
  var height = viewport.height,
      width = viewport.width,
      latitude = viewport.latitude,
      longitude = viewport.longitude;
  var viewportCenter = [longitude, latitude];
  var mbsCenter = [mbsLon, mbsLat, mbsZ];
  var mbsLatProjected = [longitude, mbsLat];
  var mbsLonProjected = [mbsLon, latitude];
  var diagonalInMeters = Math.sqrt(height * height + width * width) * metersPerPixel[0];
  var distanceInMeters = getDistanceFromLatLon(viewportCenter, mbsCenter);
  var visibleHeight = height * 0.5 + mbsR / WGS84_RADIUS_X;
  var visibleWidth = width * 0.5 + mbsR / WGS84_RADIUS_X;

  if (distanceInMeters > diagonalInMeters + mbsR / WGS84_RADIUS_X) {
    return 'OUT';
  }

  if (getDistanceFromLatLon(viewportCenter, mbsLatProjected) > visibleHeight) {
    return 'OUT';
  }

  if (getDistanceFromLatLon(viewportCenter, mbsLonProjected) > visibleWidth) {
    return 'OUT';
  }

  if (tile.lodMetricValue === 0) {
    return 'DIG';
  }

  var screenSize = getI3ScreenSize(tile, frameState);
  screenSize *= qualityFactor;

  if (screenSize < 0.5) {
    return 'OUT';
  }

  if (!tile.header.children || screenSize <= tile.lodMetricValue) {
    return 'DRAW';
  } else if (tile.header.children) {
    return 'DIG';
  }

  return 'OUT';
}

function projectVertexToSphere(_ref) {
  var _ref2 = _slicedToArray(_ref, 3),
      x = _ref2[0],
      y = _ref2[1],
      z = _ref2[2];

  var azim = toRadians(x);
  var incl = toRadians(y);
  var radius = 1.0 + z / WGS84_RADIUS_X;
  var radCosInc = radius * Math.cos(incl);
  x = radCosInc * Math.cos(azim);
  y = radCosInc * Math.sin(azim);
  z = radius * Math.sin(incl);
  return [x, y, z];
}

function getDistanceFromLatLon(_ref3, _ref4) {
  var _ref5 = _slicedToArray(_ref3, 3),
      observerLon = _ref5[0],
      observerLat = _ref5[1],
      _ref5$ = _ref5[2],
      observerZ = _ref5$ === void 0 ? 0.0 : _ref5$;

  var _ref6 = _slicedToArray(_ref4, 3),
      centerLon = _ref6[0],
      centerLat = _ref6[1],
      _ref6$ = _ref6[2],
      centerZ = _ref6$ === void 0 ? 0.0 : _ref6$;

  var projectedCenter = projectVertexToSphere([centerLon, centerLat, centerZ]);
  var projectedObserver = projectVertexToSphere([observerLon, observerLat, observerZ]);
  var dx = projectedObserver[0] - projectedCenter[0];
  var dy = projectedObserver[1] - projectedCenter[1];
  var dz = projectedObserver[2] - projectedCenter[2];
  return dx * dx + dy * dy + dz * dz;
}

export function getI3ScreenSize(tile, frameState) {
  var viewport = frameState.viewport;
  var mbsLat = tile.header.mbs[1];
  var mbsLon = tile.header.mbs[0];
  var mbsZ = tile.header.mbs[2];
  var mbsR = tile.header.mbs[3];
  var mbsCenter = [mbsLon, mbsLat, mbsZ];
  var cameraPositionCartographic = viewport.unprojectPosition(viewport.cameraPosition);
  var dSquared = getDistanceFromLatLon(cameraPositionCartographic, mbsCenter);
  var mbsRNormalized = mbsR / WGS84_RADIUS_X;
  var d = dSquared - mbsRNormalized * mbsRNormalized;
  var fltMax = 3.4028235e38;

  if (d <= 0.0) {
    return 0.5 * fltMax;
  }

  var screenSizeFactor = calculateScreenSizeFactor(tile, frameState);
  screenSizeFactor *= mbsRNormalized / Math.sqrt(d) / viewport.scale;
  return screenSizeFactor;
}

function calculateScreenSizeFactor(tile, frameState) {
  var _frameState$viewport = frameState.viewport,
      width = _frameState$viewport.width,
      height = _frameState$viewport.height,
      pixelProjectionMatrix = _frameState$viewport.pixelProjectionMatrix;
  var tanOfHalfVFAngle = Math.tan(Math.atan(Math.sqrt(1.0 / (pixelProjectionMatrix[0] * pixelProjectionMatrix[0]) + 1.0 / (pixelProjectionMatrix[5] * pixelProjectionMatrix[5]))));
  var screenCircleFactor = Math.sqrt(height * height + width * width) / tanOfHalfVFAngle;
  return screenCircleFactor;
}
//# sourceMappingURL=i3s-lod.js.map