import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { Matrix4, Vector3 } from '@math.gl/core';
import { Ellipsoid } from '@math.gl/geospatial';
import { Stats } from '@probe.gl/stats';
import { RequestScheduler, assert, path } from '@loaders.gl/loader-utils';
import TilesetCache from './tileset-cache';
import { calculateTransformProps } from './helpers/transform-utils';
import { getFrameState } from './helpers/frame-state';
import { getZoomFromBoundingVolume } from './helpers/zoom';
import Tile3D from './tile-3d';
import Tileset3DTraverser from './traversers/tileset-3d-traverser';
import TilesetTraverser from './traversers/tileset-traverser';
import I3SetTraverser from './traversers/i3s-tilset-traverser';
import { TILESET_TYPE } from '../constants';
var TILES_TOTAL = 'Tiles In Tileset(s)';
var TILES_IN_MEMORY = 'Tiles In Memory';
var TILES_IN_VIEW = 'Tiles In View';
var TILES_RENDERABLE = 'Tiles To Render';
var TILES_LOADED = 'Tiles Loaded';
var TILES_LOADING = 'Tiles Loading';
var TILES_UNLOADED = 'Tiles Unloaded';
var TILES_LOAD_FAILED = 'Failed Tile Loads';
var POINTS_COUNT = 'Points';
var TILES_GPU_MEMORY = 'Tile Memory Use';

function getQueryParamString(queryParams) {
  var queryParamStrings = [];

  for (var _i = 0, _Object$keys = Object.keys(queryParams); _i < _Object$keys.length; _i++) {
    var key = _Object$keys[_i];
    queryParamStrings.push("".concat(key, "=").concat(queryParams[key]));
  }

  switch (queryParamStrings.length) {
    case 0:
      return '';

    case 1:
      return "?".concat(queryParamStrings[0]);

    default:
      return "?".concat(queryParamStrings.join('&'));
  }
}

var DEFAULT_OPTIONS = {
  ellipsoid: Ellipsoid.WGS84,
  modelMatrix: new Matrix4(),
  throttleRequests: false,
  maximumMemoryUsage: 32,
  onTileLoad: function onTileLoad() {},
  onTileUnload: function onTileUnload() {},
  onTileError: function onTileError(tile, message, url) {},
  maximumScreenSpaceError: 8
};

var Tileset3D = function () {
  function Tileset3D(json) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Tileset3D);

    assert(json);
    this.options = _objectSpread(_objectSpread({}, DEFAULT_OPTIONS), options);
    this.tileset = json;
    this.loader = json.loader;
    this.type = json.type;
    this.url = json.url;
    this.basePath = json.basePath || path.dirname(this.url);
    this.modelMatrix = this.options.modelMatrix;
    this.ellipsoid = this.options.ellipsoid;
    this.lodMetricType = json.lodMetricType;
    this.lodMetricValue = json.lodMetricValue;
    this.refine = json.root.refine;
    this.fetchOptions = this.options.fetchOptions || {};

    if (this.options.headers) {
      this.fetchOptions.headers = this.options.headers;
    }

    if (this.options.token) {
      this.fetchOptions.token = this.options.token;
    }

    this.root = null;
    this.cartographicCenter = null;
    this.cartesianCenter = null;
    this.zoom = 1;
    this.boundingVolume = null;
    this._traverser = this._initializeTraverser();
    this._cache = new TilesetCache();
    this._requestScheduler = new RequestScheduler({
      throttleRequests: this.options.throttleRequests
    });
    this._frameNumber = 0;
    this._updateFrameNumber = 0;
    this._pendingCount = 0;
    this._tiles = {};
    this.selectedTiles = [];
    this._emptyTiles = [];
    this._requestedTiles = [];
    this._selectedTilesToStyle = [];
    this._queryParams = {};
    this._queryParamsString = null;
    this.maximumMemoryUsage = this.options.maximumMemoryUsage;
    this.gpuMemoryUsageInBytes = 0;
    this.stats = new Stats({
      id: this.url
    });

    this._initializeStats();

    this._hasMixedContent = false;
    this._maximumScreenSpaceError = this.options.maximumScreenSpaceError;
    this._properties = undefined;
    this._extensionsUsed = undefined;
    this._gltfUpAxis = undefined;
    this._dynamicScreenSpaceErrorComputedDensity = 0.0;
    this.extras = null;
    this.asset = {};
    this.credits = {};
    this.description = this.options.description;
    this._defaultGeometrySchema = [];

    this._initializeTileSet(json, this.options);
  }

  _createClass(Tileset3D, [{
    key: "isLoaded",
    value: function isLoaded() {
      return this._pendingCount === 0;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this._destroy();
    }
  }, {
    key: "getTileUrl",
    value: function getTileUrl(tilePath) {
      var isDataUrl = tilePath.startsWith('data:');

      if (isDataUrl) {
        return tilePath;
      }

      return "".concat(tilePath).concat(this.queryParams);
    }
  }, {
    key: "update",
    value: function update(viewport) {
      this._cache.reset();

      this._frameNumber++;
      this._frameState = getFrameState(viewport, this._frameNumber);

      this._traverser.traverse(this.root, this._frameState, this.options);
    }
  }, {
    key: "_onTraversalEnd",
    value: function _onTraversalEnd() {
      var selectedTiles = Object.values(this._traverser.selectedTiles);

      if (this._tilesChanged(this.selectedTiles, selectedTiles)) {
        this._updateFrameNumber++;
      }

      this.selectedTiles = selectedTiles;

      var _iterator = _createForOfIteratorHelper(this.selectedTiles),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var tile = _step.value;
          this._tiles[tile.id] = tile;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      this._requestedTiles = Object.values(this._traverser.requestedTiles);
      this._emptyTiles = Object.values(this._traverser.emptyTiles);

      this._loadTiles(this._frameState);

      this._unloadTiles();

      this._updateStats();

      return this._updateFrameNumber;
    }
  }, {
    key: "_tilesChanged",
    value: function _tilesChanged(oldSelectedTiles, selectedTiles) {
      if (oldSelectedTiles.length !== selectedTiles.length) {
        return true;
      }

      var set1 = new Set(oldSelectedTiles.map(function (t) {
        return t.id;
      }));
      var set2 = new Set(selectedTiles.map(function (t) {
        return t.id;
      }));
      var changed = oldSelectedTiles.filter(function (x) {
        return !set2.has(x.id);
      }).length > 0;
      changed = changed || selectedTiles.filter(function (x) {
        return !set1.has(x.id);
      }).length > 0;
      return changed;
    }
  }, {
    key: "_loadTiles",
    value: function _loadTiles(frameState) {
      var _iterator2 = _createForOfIteratorHelper(this._requestedTiles),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var tile = _step2.value;

          if (tile.contentUnloaded) {
            this._loadTile(tile, frameState);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }, {
    key: "_unloadTiles",
    value: function _unloadTiles() {
      this._cache.unloadTiles(this, function (tileset, tile) {
        return tileset._unloadTile(tile);
      });
    }
  }, {
    key: "_updateStats",
    value: function _updateStats() {
      var tilesRenderable = 0;
      var pointsRenderable = 0;

      var _iterator3 = _createForOfIteratorHelper(this.selectedTiles),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var tile = _step3.value;

          if (tile.contentAvailable) {
            tilesRenderable++;

            if (tile.content.pointCount) {
              pointsRenderable += tile.content.pointCount;
            }
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      this.stats.get(TILES_IN_VIEW).count = this.selectedTiles.length;
      this.stats.get(TILES_RENDERABLE).count = tilesRenderable;
      this.stats.get(POINTS_COUNT).count = pointsRenderable;
    }
  }, {
    key: "_initializeTileSet",
    value: function _initializeTileSet(tilesetJson) {
      this.root = this._initializeTileHeaders(tilesetJson, null, this.basePath);

      if (this.type === TILESET_TYPE.TILES3D) {
        this._initializeCesiumTileset(tilesetJson);
      }

      if (this.type === TILESET_TYPE.I3S) {
        this._initializeI3STileset(tilesetJson);
      }

      this._calculateViewProps();
    }
  }, {
    key: "_calculateViewProps",
    value: function _calculateViewProps() {
      var root = this.root;
      var center = root.boundingVolume.center;

      if (!center) {
        console.warn('center was not pre-calculated for the root tile');
        this.cartographicCenter = new Vector3();
        this.zoom = 1;
        return;
      }

      this.cartographicCenter = Ellipsoid.WGS84.cartesianToCartographic(center, new Vector3());
      this.cartesianCenter = center;
      this.zoom = getZoomFromBoundingVolume(root.boundingVolume);
    }
  }, {
    key: "_initializeStats",
    value: function _initializeStats() {
      this.stats.get(TILES_TOTAL);
      this.stats.get(TILES_LOADING);
      this.stats.get(TILES_IN_MEMORY);
      this.stats.get(TILES_IN_VIEW);
      this.stats.get(TILES_RENDERABLE);
      this.stats.get(TILES_LOADED);
      this.stats.get(TILES_UNLOADED);
      this.stats.get(TILES_LOAD_FAILED);
      this.stats.get(POINTS_COUNT, 'memory');
      this.stats.get(TILES_GPU_MEMORY, 'memory');
    }
  }, {
    key: "_initializeTileHeaders",
    value: function _initializeTileHeaders(tilesetJson, parentTileHeader, basePath) {
      var rootTile = new Tile3D(this, tilesetJson.root, parentTileHeader, basePath);

      if (parentTileHeader) {
        parentTileHeader.children.push(rootTile);
        rootTile.depth = parentTileHeader.depth + 1;
      }

      if (this.type === TILESET_TYPE.TILES3D) {
        var stack = [];
        stack.push(rootTile);

        while (stack.length > 0) {
          var tile = stack.pop();
          this.stats.get(TILES_TOTAL).incrementCount();
          var children = tile.header.children || [];

          var _iterator4 = _createForOfIteratorHelper(children),
              _step4;

          try {
            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
              var childHeader = _step4.value;
              var childTile = new Tile3D(this, childHeader, tile, basePath);
              tile.children.push(childTile);
              childTile.depth = tile.depth + 1;
              stack.push(childTile);
            }
          } catch (err) {
            _iterator4.e(err);
          } finally {
            _iterator4.f();
          }
        }
      }

      return rootTile;
    }
  }, {
    key: "_initializeTraverser",
    value: function _initializeTraverser() {
      var TraverserClass;
      var type = this.type;

      switch (type) {
        case TILESET_TYPE.TILES3D:
          TraverserClass = Tileset3DTraverser;
          break;

        case TILESET_TYPE.I3S:
          TraverserClass = I3SetTraverser;
          break;

        default:
          TraverserClass = TilesetTraverser;
      }

      return new TraverserClass({
        basePath: this.basePath,
        onTraversalEnd: this._onTraversalEnd.bind(this)
      });
    }
  }, {
    key: "_destroyTileHeaders",
    value: function _destroyTileHeaders(parentTile) {
      this._destroySubtree(parentTile);
    }
  }, {
    key: "_loadTile",
    value: function () {
      var _loadTile2 = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(tile, frameState) {
        var loaded;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;

                this._onStartTileLoading();

                _context.next = 4;
                return tile.loadContent(frameState);

              case 4:
                loaded = _context.sent;
                _context.next = 10;
                break;

              case 7:
                _context.prev = 7;
                _context.t0 = _context["catch"](0);

                this._onTileLoadError(tile, _context.t0);

              case 10:
                _context.prev = 10;

                this._onEndTileLoading();

                this._onTileLoad(tile, loaded);

                return _context.finish(10);

              case 14:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 7, 10, 14]]);
      }));

      function _loadTile(_x, _x2) {
        return _loadTile2.apply(this, arguments);
      }

      return _loadTile;
    }()
  }, {
    key: "_onTileLoadError",
    value: function _onTileLoadError(tile, error) {
      this.stats.get(TILES_LOAD_FAILED).incrementCount();
      var message = error.message || error.toString();
      var url = tile.url;
      console.error("A 3D tile failed to load: ".concat(tile.url, " ").concat(message));
      this.options.onTileError(tile, message, url);
    }
  }, {
    key: "_onTileLoad",
    value: function _onTileLoad(tile, loaded) {
      if (!loaded) {
        return;
      }

      if (tile && tile.content) {
        calculateTransformProps(tile, tile.content);
      }

      this._addTileToCache(tile);

      this.options.onTileLoad(tile);
    }
  }, {
    key: "_onStartTileLoading",
    value: function _onStartTileLoading() {
      this._pendingCount++;
      this.stats.get(TILES_LOADING).incrementCount();
    }
  }, {
    key: "_onEndTileLoading",
    value: function _onEndTileLoading() {
      this._pendingCount--;
      this.stats.get(TILES_LOADING).decrementCount();
    }
  }, {
    key: "_addTileToCache",
    value: function _addTileToCache(tile) {
      this._cache.add(this, tile, function (tileset) {
        return tileset._updateCacheStats(tile);
      });
    }
  }, {
    key: "_updateCacheStats",
    value: function _updateCacheStats(tile) {
      this.stats.get(TILES_LOADED).incrementCount();
      this.stats.get(TILES_IN_MEMORY).incrementCount();
      this.gpuMemoryUsageInBytes += tile.content.byteLength || 0;
      this.stats.get(TILES_GPU_MEMORY).count = this.gpuMemoryUsageInBytes;
    }
  }, {
    key: "_unloadTile",
    value: function _unloadTile(tile) {
      this.gpuMemoryUsageInBytes -= tile.content.byteLength || 0;
      this.stats.get(TILES_IN_MEMORY).decrementCount();
      this.stats.get(TILES_UNLOADED).incrementCount();
      this.stats.get(TILES_GPU_MEMORY).count = this.gpuMemoryUsageInBytes;
      this.options.onTileUnload(tile);
      tile.unloadContent();
    }
  }, {
    key: "_destroy",
    value: function _destroy() {
      var stack = [];

      if (this.root) {
        stack.push(this.root);
      }

      while (stack.length > 0) {
        var tile = stack.pop();

        var _iterator5 = _createForOfIteratorHelper(tile.children),
            _step5;

        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var child = _step5.value;
            stack.push(child);
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }

        this._destroyTile(tile);
      }

      this.root = null;
    }
  }, {
    key: "_destroySubtree",
    value: function _destroySubtree(tile) {
      var root = tile;
      var stack = [];
      stack.push(root);

      while (stack.length > 0) {
        tile = stack.pop();

        var _iterator6 = _createForOfIteratorHelper(tile.children),
            _step6;

        try {
          for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
            var child = _step6.value;
            stack.push(child);
          }
        } catch (err) {
          _iterator6.e(err);
        } finally {
          _iterator6.f();
        }

        if (tile !== root) {
          this._destroyTile(tile);
        }
      }

      root.children = [];
    }
  }, {
    key: "_destroyTile",
    value: function _destroyTile(tile) {
      this._cache.unloadTile(this, tile);

      this._unloadTile(tile);

      tile.destroy();
    }
  }, {
    key: "_initializeCesiumTileset",
    value: function _initializeCesiumTileset(tilesetJson) {
      this.asset = tilesetJson.asset;

      if (!this.asset) {
        throw new Error('Tileset must have an asset property.');
      }

      if (this.asset.version !== '0.0' && this.asset.version !== '1.0') {
        throw new Error('The tileset must be 3D Tiles version 0.0 or 1.0.');
      }

      if ('tilesetVersion' in this.asset) {
        this._queryParams.v = this.asset.tilesetVersion;
      }

      this.credits = {
        attributions: this.options.attributions || []
      };
      this.description = this.options.description;
      this.properties = tilesetJson.properties;
      this.geometricError = tilesetJson.geometricError;
      this._extensionsUsed = tilesetJson.extensionsUsed;
      this.extras = tilesetJson.extras;
    }
  }, {
    key: "_initializeI3STileset",
    value: function _initializeI3STileset(tilesetJson) {
      if ('token' in this.options) {
        this._queryParams.token = this.options.token;
      }

      this._defaultGeometrySchema = tilesetJson.store.defaultGeometrySchema;
    }
  }, {
    key: "hasExtension",
    value: function hasExtension(extensionName) {
      return Boolean(this._extensionsUsed && this._extensionsUsed.indexOf(extensionName) > -1);
    }
  }, {
    key: "tiles",
    get: function get() {
      return Object.values(this._tiles);
    }
  }, {
    key: "queryParams",
    get: function get() {
      if (!this._queryParamsString) {
        this._queryParamsString = getQueryParamString(this._queryParams);
      }

      return this._queryParamsString;
    }
  }]);

  return Tileset3D;
}();

export { Tileset3D as default };
//# sourceMappingURL=tileset-3d.js.map