import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
var STATUS = {
  REQUESTED: 'REQUESTED',
  COMPLETED: 'COMPLETED',
  ERROR: 'ERROR'
};

var I3STileManager = function () {
  function I3STileManager() {
    _classCallCheck(this, I3STileManager);

    this._statusMap = {};
  }

  _createClass(I3STileManager, [{
    key: "add",
    value: function add(request, key, callback, frameState) {
      var _this = this;

      if (!this._statusMap[key]) {
        this._statusMap[key] = {
          request: request,
          callback: callback,
          key: key,
          frameState: frameState,
          status: STATUS.REQUESTED
        };
        request().then(function (data) {
          _this._statusMap[key].status = STATUS.COMPLETED;

          _this._statusMap[key].callback(data, frameState);
        })["catch"](function (error) {
          _this._statusMap[key].status = STATUS.ERROR;
          callback(error);
        });
      }
    }
  }, {
    key: "update",
    value: function update(key, frameState) {
      if (this._statusMap[key]) {
        this._statusMap[key].frameState = frameState;
      }
    }
  }, {
    key: "find",
    value: function find(key) {
      return this._statusMap[key];
    }
  }]);

  return I3STileManager;
}();

export { I3STileManager as default };
//# sourceMappingURL=i3s-tile-manager.js.map