"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _webgl = require("@luma.gl/webgl");

var _shadertools = require("@luma.gl/shadertools");

var _transformShaderUtils = require("./transform-shader-utils");

var _SRC_TEX_PARAMETER_OV;

var SRC_TEX_PARAMETER_OVERRIDES = (_SRC_TEX_PARAMETER_OV = {}, (0, _defineProperty2["default"])(_SRC_TEX_PARAMETER_OV, 10241, 9728), (0, _defineProperty2["default"])(_SRC_TEX_PARAMETER_OV, 10240, 9728), (0, _defineProperty2["default"])(_SRC_TEX_PARAMETER_OV, 10242, 33071), (0, _defineProperty2["default"])(_SRC_TEX_PARAMETER_OV, 10243, 33071), _SRC_TEX_PARAMETER_OV);
var FS_OUTPUT_VARIABLE = 'transform_output';

var TextureTransform = function () {
  function TextureTransform(gl) {
    var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2["default"])(this, TextureTransform);
    this.gl = gl;
    this.currentIndex = 0;
    this._swapTexture = null;
    this.targetTextureVarying = null;
    this.targetTextureType = null;
    this.samplerTextureMap = null;
    this.bindings = [];
    this.resources = {};

    this._initialize(props);

    Object.seal(this);
  }

  (0, _createClass2["default"])(TextureTransform, [{
    key: "updateModelProps",
    value: function updateModelProps() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var updatedModelProps = this._processVertexShader(props);

      return Object.assign({}, props, updatedModelProps);
    }
  }, {
    key: "getDrawOptions",
    value: function getDrawOptions() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _this$bindings$this$c = this.bindings[this.currentIndex],
          sourceBuffers = _this$bindings$this$c.sourceBuffers,
          sourceTextures = _this$bindings$this$c.sourceTextures,
          framebuffer = _this$bindings$this$c.framebuffer,
          targetTexture = _this$bindings$this$c.targetTexture;
      var attributes = Object.assign({}, sourceBuffers, opts.attributes);
      var uniforms = Object.assign({}, opts.uniforms);
      var parameters = Object.assign({}, opts.parameters);
      var discard = opts.discard;

      if (this.hasSourceTextures || this.hasTargetTexture) {
        attributes.transform_elementID = this.elementIDBuffer;

        for (var sampler in this.samplerTextureMap) {
          var textureName = this.samplerTextureMap[sampler];
          uniforms[sampler] = sourceTextures[textureName];
        }

        this._setSourceTextureParameters();

        var sizeUniforms = (0, _transformShaderUtils.getSizeUniforms)({
          sourceTextureMap: sourceTextures,
          targetTextureVarying: this.targetTextureVarying,
          targetTexture: targetTexture
        });
        Object.assign(uniforms, sizeUniforms);
      }

      if (this.hasTargetTexture) {
        discard = false;
        parameters.viewport = [0, 0, framebuffer.width, framebuffer.height];
      }

      return {
        attributes: attributes,
        framebuffer: framebuffer,
        uniforms: uniforms,
        discard: discard,
        parameters: parameters
      };
    }
  }, {
    key: "swap",
    value: function swap() {
      if (this._swapTexture) {
        this.currentIndex = this._getNextIndex();
        return true;
      }

      return false;
    }
  }, {
    key: "update",
    value: function update() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      this._setupTextures(opts);
    }
  }, {
    key: "getTargetTexture",
    value: function getTargetTexture() {
      var targetTexture = this.bindings[this.currentIndex].targetTexture;
      return targetTexture;
    }
  }, {
    key: "getData",
    value: function getData() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$packed = _ref.packed,
          packed = _ref$packed === void 0 ? false : _ref$packed;

      var framebuffer = this.bindings[this.currentIndex].framebuffer;
      var pixels = (0, _webgl.readPixelsToArray)(framebuffer);

      if (!packed) {
        return pixels;
      }

      var ArrayType = pixels.constructor;
      var channelCount = (0, _shadertools.typeToChannelCount)(this.targetTextureType);
      var packedPixels = new ArrayType(pixels.length * channelCount / 4);
      var packCount = 0;

      for (var i = 0; i < pixels.length; i += 4) {
        for (var j = 0; j < channelCount; j++) {
          packedPixels[packCount++] = pixels[i + j];
        }
      }

      return packedPixels;
    }
  }, {
    key: "getFramebuffer",
    value: function getFramebuffer() {
      var currentResources = this.bindings[this.currentIndex];
      return currentResources.framebuffer;
    }
  }, {
    key: "delete",
    value: function _delete() {
      if (this.ownTexture) {
        this.ownTexture["delete"]();
      }

      if (this.elementIDBuffer) {
        this.elementIDBuffer["delete"]();
      }
    }
  }, {
    key: "_initialize",
    value: function _initialize() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _targetTextureVarying = props._targetTextureVarying,
          _swapTexture = props._swapTexture;
      this._swapTexture = _swapTexture;
      this.targetTextureVarying = _targetTextureVarying;
      this.hasTargetTexture = _targetTextureVarying;

      this._setupTextures(props);
    }
  }, {
    key: "_createTargetTexture",
    value: function _createTargetTexture(props) {
      var sourceTextures = props.sourceTextures,
          textureOrReference = props.textureOrReference;

      if (textureOrReference instanceof _webgl.Texture2D) {
        return textureOrReference;
      }

      var refTexture = sourceTextures[textureOrReference];

      if (!refTexture) {
        return null;
      }

      this._targetRefTexName = textureOrReference;
      return this._createNewTexture(refTexture);
    }
  }, {
    key: "_setupTextures",
    value: function _setupTextures() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var sourceBuffers = props.sourceBuffers,
          _props$_sourceTexture = props._sourceTextures,
          _sourceTextures = _props$_sourceTexture === void 0 ? {} : _props$_sourceTexture,
          _targetTexture = props._targetTexture;

      var targetTexture = this._createTargetTexture({
        sourceTextures: _sourceTextures,
        textureOrReference: _targetTexture
      });

      this.hasSourceTextures = this.hasSourceTextures || _sourceTextures && Object.keys(_sourceTextures).length > 0;

      this._updateBindings({
        sourceBuffers: sourceBuffers,
        sourceTextures: _sourceTextures,
        targetTexture: targetTexture
      });

      if ('elementCount' in props) {
        this._updateElementIDBuffer(props.elementCount);
      }
    }
  }, {
    key: "_updateElementIDBuffer",
    value: function _updateElementIDBuffer(elementCount) {
      if (typeof elementCount !== 'number' || this.elementCount >= elementCount) {
        return;
      }

      var elementIds = new Float32Array(elementCount);
      elementIds.forEach(function (_, index, array) {
        array[index] = index;
      });

      if (!this.elementIDBuffer) {
        this.elementIDBuffer = new _webgl.Buffer(this.gl, {
          data: elementIds,
          accessor: {
            size: 1
          }
        });
      } else {
        this.elementIDBuffer.setData({
          data: elementIds
        });
      }

      this.elementCount = elementCount;
    }
  }, {
    key: "_updateBindings",
    value: function _updateBindings(opts) {
      this.bindings[this.currentIndex] = this._updateBinding(this.bindings[this.currentIndex], opts);

      if (this._swapTexture) {
        var _this$_swapTextures = this._swapTextures(this.bindings[this.currentIndex]),
            sourceTextures = _this$_swapTextures.sourceTextures,
            targetTexture = _this$_swapTextures.targetTexture;

        var nextIndex = this._getNextIndex();

        this.bindings[nextIndex] = this._updateBinding(this.bindings[nextIndex], {
          sourceTextures: sourceTextures,
          targetTexture: targetTexture
        });
      }
    }
  }, {
    key: "_updateBinding",
    value: function _updateBinding(binding, opts) {
      var sourceBuffers = opts.sourceBuffers,
          sourceTextures = opts.sourceTextures,
          targetTexture = opts.targetTexture;

      if (!binding) {
        binding = {
          sourceBuffers: {},
          sourceTextures: {},
          targetTexture: null
        };
      }

      Object.assign(binding.sourceTextures, sourceTextures);
      Object.assign(binding.sourceBuffers, sourceBuffers);

      if (targetTexture) {
        binding.targetTexture = targetTexture;
        var width = targetTexture.width,
            height = targetTexture.height;
        var _binding = binding,
            framebuffer = _binding.framebuffer;

        if (framebuffer) {
          framebuffer.update({
            attachments: (0, _defineProperty2["default"])({}, 36064, targetTexture),
            resizeAttachments: false
          });
          framebuffer.resize({
            width: width,
            height: height
          });
        } else {
          binding.framebuffer = new _webgl.Framebuffer(this.gl, {
            id: "".concat(this.id || 'transform', "-framebuffer"),
            width: width,
            height: height,
            attachments: (0, _defineProperty2["default"])({}, 36064, targetTexture)
          });
        }
      }

      return binding;
    }
  }, {
    key: "_setSourceTextureParameters",
    value: function _setSourceTextureParameters() {
      var index = this.currentIndex;
      var sourceTextures = this.bindings[index].sourceTextures;

      for (var name in sourceTextures) {
        sourceTextures[name].setParameters(SRC_TEX_PARAMETER_OVERRIDES);
      }
    }
  }, {
    key: "_swapTextures",
    value: function _swapTextures(opts) {
      if (!this._swapTexture) {
        return null;
      }

      var sourceTextures = Object.assign({}, opts.sourceTextures);
      sourceTextures[this._swapTexture] = opts.targetTexture;
      var targetTexture = opts.sourceTextures[this._swapTexture];
      return {
        sourceTextures: sourceTextures,
        targetTexture: targetTexture
      };
    }
  }, {
    key: "_createNewTexture",
    value: function _createNewTexture(refTexture) {
      var _parameters;

      var texture = (0, _webgl.cloneTextureFrom)(refTexture, {
        parameters: (_parameters = {}, (0, _defineProperty2["default"])(_parameters, 10241, 9728), (0, _defineProperty2["default"])(_parameters, 10240, 9728), (0, _defineProperty2["default"])(_parameters, 10242, 33071), (0, _defineProperty2["default"])(_parameters, 10243, 33071), _parameters),
        pixelStore: (0, _defineProperty2["default"])({}, 37440, false)
      });

      if (this.ownTexture) {
        this.ownTexture["delete"]();
      }

      this.ownTexture = texture;
      return texture;
    }
  }, {
    key: "_getNextIndex",
    value: function _getNextIndex() {
      return (this.currentIndex + 1) % 2;
    }
  }, {
    key: "_processVertexShader",
    value: function _processVertexShader() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _this$bindings$this$c2 = this.bindings[this.currentIndex],
          sourceTextures = _this$bindings$this$c2.sourceTextures,
          targetTexture = _this$bindings$this$c2.targetTexture;

      var _updateForTextures = (0, _transformShaderUtils.updateForTextures)({
        vs: props.vs,
        sourceTextureMap: sourceTextures,
        targetTextureVarying: this.targetTextureVarying,
        targetTexture: targetTexture
      }),
          vs = _updateForTextures.vs,
          uniforms = _updateForTextures.uniforms,
          targetTextureType = _updateForTextures.targetTextureType,
          inject = _updateForTextures.inject,
          samplerTextureMap = _updateForTextures.samplerTextureMap;

      var combinedInject = (0, _shadertools.combineInjects)([props.inject || {}, inject]);
      this.targetTextureType = targetTextureType;
      this.samplerTextureMap = samplerTextureMap;
      var fs = props._fs || (0, _shadertools.getPassthroughFS)({
        version: (0, _webgl.getShaderVersion)(vs),
        input: this.targetTextureVarying,
        inputType: targetTextureType,
        output: FS_OUTPUT_VARIABLE
      });
      var modules = this.hasSourceTextures || this.targetTextureVarying ? [_shadertools._transform].concat(props.modules || []) : props.modules;
      return {
        vs: vs,
        fs: fs,
        modules: modules,
        uniforms: uniforms,
        inject: combinedInject
      };
    }
  }]);
  return TextureTransform;
}();

exports["default"] = TextureTransform;
//# sourceMappingURL=texture-transform.js.map