export function unpackIndexedGeometry(geometry) {
  var indices = geometry.indices,
      attributes = geometry.attributes;

  if (!indices) {
    return geometry;
  }

  var vertexCount = indices.value.length;
  var unpackedAttributes = {};

  for (var attributeName in attributes) {
    var attribute = attributes[attributeName];
    var constant = attribute.constant,
        value = attribute.value,
        size = attribute.size;

    if (constant || !size) {
      continue;
    }

    var unpackedValue = new value.constructor(vertexCount * size);

    for (var x = 0; x < vertexCount; ++x) {
      var index = indices.value[x];

      for (var i = 0; i < size; i++) {
        unpackedValue[x * size + i] = value[index * size + i];
      }
    }

    unpackedAttributes[attributeName] = {
      size: size,
      value: unpackedValue
    };
  }

  return {
    attributes: Object.assign({}, attributes, unpackedAttributes)
  };
}
//# sourceMappingURL=geometry-utils.js.map