import _typeof from "@babel/runtime/helpers/esm/typeof";
import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { isWebGL, createGLContext, instrumentGLContext, resizeGLContext, resetParameters } from '@luma.gl/gltools';
import { requestAnimationFrame, cancelAnimationFrame, Query, lumaStats, Framebuffer, log, assert } from '@luma.gl/webgl';
import { isBrowser } from 'probe.gl/env';
var isPage = isBrowser() && typeof document !== 'undefined';
var statIdCounter = 0;

var AnimationLoop = function () {
  function AnimationLoop() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, AnimationLoop);

    var _props$onCreateContex = props.onCreateContext,
        onCreateContext = _props$onCreateContex === void 0 ? function (opts) {
      return createGLContext(opts);
    } : _props$onCreateContex,
        _props$onAddHTML = props.onAddHTML,
        onAddHTML = _props$onAddHTML === void 0 ? null : _props$onAddHTML,
        _props$onInitialize = props.onInitialize,
        onInitialize = _props$onInitialize === void 0 ? function () {} : _props$onInitialize,
        _props$onRender = props.onRender,
        onRender = _props$onRender === void 0 ? function () {} : _props$onRender,
        _props$onFinalize = props.onFinalize,
        onFinalize = _props$onFinalize === void 0 ? function () {} : _props$onFinalize,
        onError = props.onError,
        _props$gl = props.gl,
        gl = _props$gl === void 0 ? null : _props$gl,
        _props$glOptions = props.glOptions,
        glOptions = _props$glOptions === void 0 ? {} : _props$glOptions,
        _props$debug = props.debug,
        debug = _props$debug === void 0 ? false : _props$debug,
        _props$createFramebuf = props.createFramebuffer,
        createFramebuffer = _props$createFramebuf === void 0 ? false : _props$createFramebuf,
        _props$autoResizeView = props.autoResizeViewport,
        autoResizeViewport = _props$autoResizeView === void 0 ? true : _props$autoResizeView,
        _props$autoResizeDraw = props.autoResizeDrawingBuffer,
        autoResizeDrawingBuffer = _props$autoResizeDraw === void 0 ? true : _props$autoResizeDraw,
        _props$stats = props.stats,
        stats = _props$stats === void 0 ? lumaStats.get("animation-loop-".concat(statIdCounter++)) : _props$stats;
    var _props$useDevicePixel = props.useDevicePixels,
        useDevicePixels = _props$useDevicePixel === void 0 ? true : _props$useDevicePixel;

    if ('useDevicePixelRatio' in props) {
      log.deprecated('useDevicePixelRatio', 'useDevicePixels')();
      useDevicePixels = props.useDevicePixelRatio;
    }

    this.props = {
      onCreateContext: onCreateContext,
      onAddHTML: onAddHTML,
      onInitialize: onInitialize,
      onRender: onRender,
      onFinalize: onFinalize,
      onError: onError,
      gl: gl,
      glOptions: glOptions,
      debug: debug,
      createFramebuffer: createFramebuffer
    };
    this.gl = gl;
    this.needsRedraw = null;
    this.timeline = null;
    this.stats = stats;
    this.cpuTime = this.stats.get('CPU Time');
    this.gpuTime = this.stats.get('GPU Time');
    this.frameRate = this.stats.get('Frame Rate');
    this._initialized = false;
    this._running = false;
    this._animationFrameId = null;
    this._nextFramePromise = null;
    this._resolveNextFrame = null;
    this._cpuStartTime = 0;
    this.setProps({
      autoResizeViewport: autoResizeViewport,
      autoResizeDrawingBuffer: autoResizeDrawingBuffer,
      useDevicePixels: useDevicePixels
    });
    this.start = this.start.bind(this);
    this.stop = this.stop.bind(this);
    this._pageLoadPromise = null;
    this._onMousemove = this._onMousemove.bind(this);
    this._onMouseleave = this._onMouseleave.bind(this);
  }

  _createClass(AnimationLoop, [{
    key: "delete",
    value: function _delete() {
      this.stop();

      this._setDisplay(null);
    }
  }, {
    key: "setNeedsRedraw",
    value: function setNeedsRedraw(reason) {
      assert(typeof reason === 'string');
      this.needsRedraw = this.needsRedraw || reason;
      return this;
    }
  }, {
    key: "setProps",
    value: function setProps(props) {
      if ('autoResizeViewport' in props) {
        this.autoResizeViewport = props.autoResizeViewport;
      }

      if ('autoResizeDrawingBuffer' in props) {
        this.autoResizeDrawingBuffer = props.autoResizeDrawingBuffer;
      }

      if ('useDevicePixels' in props) {
        this.useDevicePixels = props.useDevicePixels;
      }

      return this;
    }
  }, {
    key: "start",
    value: function start() {
      var _this = this;

      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (this._running) {
        return this;
      }

      this._running = true;

      var startPromise = this._getPageLoadPromise().then(function () {
        if (!_this._running || _this._initialized) {
          return null;
        }

        _this._createWebGLContext(opts);

        _this._createFramebuffer();

        _this._startEventHandling();

        _this._initializeCallbackData();

        _this._updateCallbackData();

        _this._resizeCanvasDrawingBuffer();

        _this._resizeViewport();

        _this._gpuTimeQuery = Query.isSupported(_this.gl, ['timers']) ? new Query(_this.gl) : null;
        _this._initialized = true;
        return _this.onInitialize(_this.animationProps);
      }).then(function (appContext) {
        if (_this._running) {
          _this._addCallbackData(appContext || {});

          if (appContext !== false) {
            _this._startLoop();
          }
        }
      });

      if (this.props.onError) {
        startPromise["catch"](this.props.onError);
      }

      return this;
    }
  }, {
    key: "redraw",
    value: function redraw() {
      this._beginTimers();

      this._setupFrame();

      this._updateCallbackData();

      this._renderFrame(this.animationProps);

      this._clearNeedsRedraw();

      if (this.offScreen && this.gl.commit) {
        this.gl.commit();
      }

      if (this._resolveNextFrame) {
        this._resolveNextFrame(this);

        this._nextFramePromise = null;
        this._resolveNextFrame = null;
      }

      this._endTimers();

      return this;
    }
  }, {
    key: "stop",
    value: function stop() {
      if (this._running) {
        this._finalizeCallbackData();

        cancelAnimationFrame(this._animationFrameId);
        this._nextFramePromise = null;
        this._resolveNextFrame = null;
        this._animationFrameId = null;
        this._running = false;
      }

      return this;
    }
  }, {
    key: "attachTimeline",
    value: function attachTimeline(timeline) {
      this.timeline = timeline;
      return this.timeline;
    }
  }, {
    key: "detachTimeline",
    value: function detachTimeline() {
      this.timeline = null;
    }
  }, {
    key: "waitForRender",
    value: function waitForRender() {
      var _this2 = this;

      this.setNeedsRedraw('waitForRender');

      if (!this._nextFramePromise) {
        this._nextFramePromise = new Promise(function (resolve) {
          _this2._resolveNextFrame = resolve;
        });
      }

      return this._nextFramePromise;
    }
  }, {
    key: "toDataURL",
    value: function () {
      var _toDataURL = _asyncToGenerator(_regeneratorRuntime.mark(function _callee() {
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                this.setNeedsRedraw('toDataURL');
                _context.next = 3;
                return this.waitForRender();

              case 3:
                return _context.abrupt("return", this.gl.canvas.toDataURL());

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function toDataURL() {
        return _toDataURL.apply(this, arguments);
      }

      return toDataURL;
    }()
  }, {
    key: "onCreateContext",
    value: function onCreateContext() {
      var _this$props;

      return (_this$props = this.props).onCreateContext.apply(_this$props, arguments);
    }
  }, {
    key: "onInitialize",
    value: function onInitialize() {
      var _this$props2;

      return (_this$props2 = this.props).onInitialize.apply(_this$props2, arguments);
    }
  }, {
    key: "onRender",
    value: function onRender() {
      var _this$props3;

      return (_this$props3 = this.props).onRender.apply(_this$props3, arguments);
    }
  }, {
    key: "onFinalize",
    value: function onFinalize() {
      var _this$props4;

      return (_this$props4 = this.props).onFinalize.apply(_this$props4, arguments);
    }
  }, {
    key: "getHTMLControlValue",
    value: function getHTMLControlValue(id) {
      var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      var element = document.getElementById(id);
      return element ? Number(element.value) : defaultValue;
    }
  }, {
    key: "setViewParameters",
    value: function setViewParameters() {
      log.removed('AnimationLoop.setViewParameters', 'AnimationLoop.setProps')();
      return this;
    }
  }, {
    key: "_startLoop",
    value: function _startLoop() {
      var _this3 = this;

      var renderFrame = function renderFrame() {
        if (!_this3._running) {
          return;
        }

        _this3.redraw();

        _this3._animationFrameId = _this3._requestAnimationFrame(renderFrame);
      };

      cancelAnimationFrame(this._animationFrameId);
      this._animationFrameId = this._requestAnimationFrame(renderFrame);
    }
  }, {
    key: "_getPageLoadPromise",
    value: function _getPageLoadPromise() {
      if (!this._pageLoadPromise) {
        this._pageLoadPromise = isPage ? new Promise(function (resolve, reject) {
          if (isPage && document.readyState === 'complete') {
            resolve(document);
            return;
          }

          window.addEventListener('load', function () {
            resolve(document);
          });
        }) : Promise.resolve({});
      }

      return this._pageLoadPromise;
    }
  }, {
    key: "_setDisplay",
    value: function _setDisplay(display) {
      if (this.display) {
        this.display["delete"]();
        this.display.animationLoop = null;
      }

      if (display) {
        display.animationLoop = this;
      }

      this.display = display;
    }
  }, {
    key: "_requestAnimationFrame",
    value: function _requestAnimationFrame(renderFrameCallback) {
      if (this.display && this.display.requestAnimationFrame(renderFrameCallback)) {
        return;
      }

      requestAnimationFrame(renderFrameCallback);
    }
  }, {
    key: "_renderFrame",
    value: function _renderFrame() {
      if (this.display) {
        var _this$display;

        (_this$display = this.display)._renderFrame.apply(_this$display, arguments);

        return;
      }

      this.onRender.apply(this, arguments);
    }
  }, {
    key: "_clearNeedsRedraw",
    value: function _clearNeedsRedraw() {
      this.needsRedraw = null;
    }
  }, {
    key: "_setupFrame",
    value: function _setupFrame() {
      if (this._onSetupFrame) {
        this._onSetupFrame(this.animationProps);
      } else {
        this._resizeCanvasDrawingBuffer();

        this._resizeViewport();

        this._resizeFramebuffer();
      }
    }
  }, {
    key: "_initializeCallbackData",
    value: function _initializeCallbackData() {
      this.animationProps = {
        gl: this.gl,
        stop: this.stop,
        canvas: this.gl.canvas,
        framebuffer: this.framebuffer,
        useDevicePixels: this.useDevicePixels,
        needsRedraw: null,
        startTime: Date.now(),
        engineTime: 0,
        tick: 0,
        tock: 0,
        time: 0,
        _timeline: this.timeline,
        _loop: this,
        _animationLoop: this,
        _mousePosition: null
      };
    }
  }, {
    key: "_updateCallbackData",
    value: function _updateCallbackData() {
      var _this$_getSizeAndAspe = this._getSizeAndAspect(),
          width = _this$_getSizeAndAspe.width,
          height = _this$_getSizeAndAspe.height,
          aspect = _this$_getSizeAndAspe.aspect;

      if (width !== this.animationProps.width || height !== this.animationProps.height) {
        this.setNeedsRedraw('drawing buffer resized');
      }

      if (aspect !== this.animationProps.aspect) {
        this.setNeedsRedraw('drawing buffer aspect changed');
      }

      this.animationProps.width = width;
      this.animationProps.height = height;
      this.animationProps.aspect = aspect;
      this.animationProps.needsRedraw = this.needsRedraw;
      this.animationProps.engineTime = Date.now() - this.animationProps.startTime;

      if (this.timeline) {
        this.timeline.update(this.animationProps.engineTime);
      }

      this.animationProps.tick = Math.floor(this.animationProps.time / 1000 * 60);
      this.animationProps.tock++;
      this.animationProps.time = this.timeline ? this.timeline.getTime() : this.animationProps.engineTime;
      this.animationProps._offScreen = this.offScreen;
    }
  }, {
    key: "_finalizeCallbackData",
    value: function _finalizeCallbackData() {
      this.onFinalize(this.animationProps);
    }
  }, {
    key: "_addCallbackData",
    value: function _addCallbackData(appContext) {
      if (_typeof(appContext) === 'object' && appContext !== null) {
        this.animationProps = Object.assign({}, this.animationProps, appContext);
      }
    }
  }, {
    key: "_createWebGLContext",
    value: function _createWebGLContext(opts) {
      this.offScreen = opts.canvas && typeof OffscreenCanvas !== 'undefined' && opts.canvas instanceof OffscreenCanvas;
      opts = Object.assign({}, opts, this.props.glOptions);
      this.gl = this.props.gl ? instrumentGLContext(this.props.gl, opts) : this.onCreateContext(opts);

      if (!isWebGL(this.gl)) {
        throw new Error('AnimationLoop.onCreateContext - illegal context returned');
      }

      resetParameters(this.gl);

      this._createInfoDiv();
    }
  }, {
    key: "_createInfoDiv",
    value: function _createInfoDiv() {
      if (this.gl.canvas && this.props.onAddHTML) {
        var wrapperDiv = document.createElement('div');
        document.body.appendChild(wrapperDiv);
        wrapperDiv.style.position = 'relative';
        var div = document.createElement('div');
        div.style.position = 'absolute';
        div.style.left = '10px';
        div.style.bottom = '10px';
        div.style.width = '300px';
        div.style.background = 'white';
        wrapperDiv.appendChild(this.gl.canvas);
        wrapperDiv.appendChild(div);
        var html = this.props.onAddHTML(div);

        if (html) {
          div.innerHTML = html;
        }
      }
    }
  }, {
    key: "_getSizeAndAspect",
    value: function _getSizeAndAspect() {
      var width = this.gl.drawingBufferWidth;
      var height = this.gl.drawingBufferHeight;
      var aspect = 1;
      var canvas = this.gl.canvas;

      if (canvas && canvas.clientHeight) {
        aspect = canvas.clientWidth / canvas.clientHeight;
      } else if (width > 0 && height > 0) {
        aspect = width / height;
      }

      return {
        width: width,
        height: height,
        aspect: aspect
      };
    }
  }, {
    key: "_resizeViewport",
    value: function _resizeViewport() {
      if (this.autoResizeViewport) {
        this.gl.viewport(0, 0, this.gl.drawingBufferWidth, this.gl.drawingBufferHeight);
      }
    }
  }, {
    key: "_resizeCanvasDrawingBuffer",
    value: function _resizeCanvasDrawingBuffer() {
      if (this.autoResizeDrawingBuffer) {
        resizeGLContext(this.gl, {
          useDevicePixels: this.useDevicePixels
        });
      }
    }
  }, {
    key: "_createFramebuffer",
    value: function _createFramebuffer() {
      if (this.props.createFramebuffer) {
        this.framebuffer = new Framebuffer(this.gl);
      }
    }
  }, {
    key: "_resizeFramebuffer",
    value: function _resizeFramebuffer() {
      if (this.framebuffer) {
        this.framebuffer.resize({
          width: this.gl.drawingBufferWidth,
          height: this.gl.drawingBufferHeight
        });
      }
    }
  }, {
    key: "_beginTimers",
    value: function _beginTimers() {
      this.frameRate.timeEnd();
      this.frameRate.timeStart();

      if (this._gpuTimeQuery && this._gpuTimeQuery.isResultAvailable() && !this._gpuTimeQuery.isTimerDisjoint()) {
        this.stats.get('GPU Time').addTime(this._gpuTimeQuery.getTimerMilliseconds());
      }

      if (this._gpuTimeQuery) {
        this._gpuTimeQuery.beginTimeElapsedQuery();
      }

      this.cpuTime.timeStart();
    }
  }, {
    key: "_endTimers",
    value: function _endTimers() {
      this.cpuTime.timeEnd();

      if (this._gpuTimeQuery) {
        this._gpuTimeQuery.end();
      }
    }
  }, {
    key: "_startEventHandling",
    value: function _startEventHandling() {
      var canvas = this.gl.canvas;

      if (canvas) {
        canvas.addEventListener('mousemove', this._onMousemove);
        canvas.addEventListener('mouseleave', this._onMouseleave);
      }
    }
  }, {
    key: "_onMousemove",
    value: function _onMousemove(e) {
      this.animationProps._mousePosition = [e.offsetX, e.offsetY];
    }
  }, {
    key: "_onMouseleave",
    value: function _onMouseleave(e) {
      this.animationProps._mousePosition = null;
    }
  }]);

  return AnimationLoop;
}();

export { AnimationLoop as default };
//# sourceMappingURL=animation-loop.js.map