import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { getPassthroughFS } from '@luma.gl/shadertools';
import BufferTransform from './buffer-transform';
import TextureTransform from './texture-transform';
import { isWebGL2 } from '@luma.gl/gltools';
import { assert, isObjectEmpty, getShaderVersion } from '@luma.gl/webgl';
import Model from '../lib/model';

var Transform = function () {
  _createClass(Transform, null, [{
    key: "isSupported",
    value: function isSupported(gl) {
      return isWebGL2(gl);
    }
  }]);

  function Transform(gl) {
    var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Transform);

    this.gl = gl;
    this.model = null;
    this.elementCount = 0;
    this.bufferTransform = null;
    this.textureTransform = null;
    this.elementIDBuffer = null;

    this._initialize(props);

    Object.seal(this);
  }

  _createClass(Transform, [{
    key: "delete",
    value: function _delete() {
      var model = this.model,
          bufferTransform = this.bufferTransform,
          textureTransform = this.textureTransform;

      if (model) {
        model["delete"]();
      }

      if (bufferTransform) {
        bufferTransform["delete"]();
      }

      if (textureTransform) {
        textureTransform["delete"]();
      }
    }
  }, {
    key: "run",
    value: function run() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _opts$clearRenderTarg = opts.clearRenderTarget,
          clearRenderTarget = _opts$clearRenderTarg === void 0 ? true : _opts$clearRenderTarg;

      var updatedOpts = this._updateDrawOptions(opts);

      if (clearRenderTarget && updatedOpts.framebuffer) {
        updatedOpts.framebuffer.clear({
          color: true
        });
      }

      this.model.transform(updatedOpts);
    }
  }, {
    key: "swap",
    value: function swap() {
      var swapped = false;
      var resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = resourceTransforms[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var resourceTransform = _step.value;
          swapped = swapped || resourceTransform.swap();
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      assert(swapped, 'Nothing to swap');
    }
  }, {
    key: "getBuffer",
    value: function getBuffer() {
      var varyingName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      return this.bufferTransform && this.bufferTransform.getBuffer(varyingName);
    }
  }, {
    key: "getData",
    value: function getData() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = resourceTransforms[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var resourceTransform = _step2.value;
          var data = resourceTransform.getData(opts);

          if (data) {
            return data;
          }
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return null;
    }
  }, {
    key: "getFramebuffer",
    value: function getFramebuffer() {
      return this.textureTransform && this.textureTransform.getFramebuffer();
    }
  }, {
    key: "update",
    value: function update() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if ('elementCount' in opts) {
        this.model.setVertexCount(opts.elementCount);
      }

      var resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = resourceTransforms[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var resourceTransform = _step3.value;
          resourceTransform.update(opts);
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3["return"] != null) {
            _iterator3["return"]();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }, {
    key: "_initialize",
    value: function _initialize() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var gl = this.gl;

      this._buildResourceTransforms(gl, props);

      props = this._updateModelProps(props);
      this.model = new Model(gl, Object.assign({}, props, {
        fs: props.fs || getPassthroughFS({
          version: getShaderVersion(props.vs)
        }),
        id: props.id || 'transform-model',
        drawMode: props.drawMode || 0,
        vertexCount: props.elementCount
      }));
      this.bufferTransform && this.bufferTransform.setupResources({
        model: this.model
      });
    }
  }, {
    key: "_updateModelProps",
    value: function _updateModelProps(props) {
      var updatedProps = Object.assign({}, props);
      var resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = resourceTransforms[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var resourceTransform = _step4.value;
          updatedProps = resourceTransform.updateModelProps(updatedProps);
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4["return"] != null) {
            _iterator4["return"]();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }

      return updatedProps;
    }
  }, {
    key: "_buildResourceTransforms",
    value: function _buildResourceTransforms(gl, props) {
      if (canCreateBufferTransform(props)) {
        this.bufferTransform = new BufferTransform(gl, props);
      }

      if (canCreateTextureTransform(props)) {
        this.textureTransform = new TextureTransform(gl, props);
      }

      assert(this.bufferTransform || this.textureTransform, 'must provide source/feedback buffers or source/target textures');
    }
  }, {
    key: "_updateDrawOptions",
    value: function _updateDrawOptions(opts) {
      var updatedOpts = Object.assign({}, opts);
      var resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);
      var _iteratorNormalCompletion5 = true;
      var _didIteratorError5 = false;
      var _iteratorError5 = undefined;

      try {
        for (var _iterator5 = resourceTransforms[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
          var resourceTransform = _step5.value;
          updatedOpts = Object.assign(updatedOpts, resourceTransform.getDrawOptions(updatedOpts));
        }
      } catch (err) {
        _didIteratorError5 = true;
        _iteratorError5 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion5 && _iterator5["return"] != null) {
            _iterator5["return"]();
          }
        } finally {
          if (_didIteratorError5) {
            throw _iteratorError5;
          }
        }
      }

      return updatedOpts;
    }
  }]);

  return Transform;
}();

export { Transform as default };

function canCreateBufferTransform(props) {
  if (!isObjectEmpty(props.feedbackBuffers) || !isObjectEmpty(props.feedbackMap) || props.varyings && props.varyings.length > 0) {
    return true;
  }

  return false;
}

function canCreateTextureTransform(props) {
  if (!isObjectEmpty(props._sourceTextures) || props._targetTexture || props._targetTextureVarying) {
    return true;
  }

  return false;
}
//# sourceMappingURL=transform.js.map