import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { assembleShaders } from '@luma.gl/shadertools';
import { Program } from '@luma.gl/webgl';

var ProgramManager = function () {
  _createClass(ProgramManager, null, [{
    key: "getDefaultProgramManager",
    value: function getDefaultProgramManager(gl) {
      gl.luma = gl.luma || {};
      gl.luma.defaultProgramManager = gl.luma.defaultProgramManager || new ProgramManager(gl);
      return gl.luma.defaultProgramManager;
    }
  }]);

  function ProgramManager(gl) {
    _classCallCheck(this, ProgramManager);

    this.gl = gl;
    this._programCache = {};
    this._getUniforms = {};
    this._registeredModules = {};
    this._hookFunctions = [];
    this._defaultModules = [];
    this._hashes = {};
    this._hashCounter = 0;
    this.stateHash = 0;
    this._useCounts = {};
  }

  _createClass(ProgramManager, [{
    key: "addDefaultModule",
    value: function addDefaultModule(module) {
      if (!this._defaultModules.find(function (m) {
        return m.name === module.name;
      })) {
        this._defaultModules.push(module);
      }

      this.stateHash++;
    }
  }, {
    key: "removeDefaultModule",
    value: function removeDefaultModule(module) {
      var moduleName = typeof module === 'string' ? module : module.name;
      this._defaultModules = this._defaultModules.filter(function (m) {
        return m.name !== moduleName;
      });
      this.stateHash++;
    }
  }, {
    key: "addShaderHook",
    value: function addShaderHook(hook, opts) {
      if (opts) {
        hook = Object.assign(opts, {
          hook: hook
        });
      }

      this._hookFunctions.push(hook);

      this.stateHash++;
    }
  }, {
    key: "get",
    value: function get() {
      var _this = this;

      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _props$vs = props.vs,
          vs = _props$vs === void 0 ? '' : _props$vs,
          _props$fs = props.fs,
          fs = _props$fs === void 0 ? '' : _props$fs,
          _props$defines = props.defines,
          defines = _props$defines === void 0 ? {} : _props$defines,
          _props$inject = props.inject,
          inject = _props$inject === void 0 ? {} : _props$inject,
          _props$varyings = props.varyings,
          varyings = _props$varyings === void 0 ? [] : _props$varyings,
          _props$bufferMode = props.bufferMode,
          bufferMode = _props$bufferMode === void 0 ? 0x8c8d : _props$bufferMode,
          _props$transpileToGLS = props.transpileToGLSL100,
          transpileToGLSL100 = _props$transpileToGLS === void 0 ? false : _props$transpileToGLS;

      var modules = this._getModuleList(props.modules);

      var vsHash = this._getHash(vs);

      var fsHash = this._getHash(fs);

      var moduleHashes = modules.map(function (m) {
        return _this._getHash(m.name);
      }).sort();
      var varyingHashes = varyings.map(function (v) {
        return _this._getHash(v);
      });
      var defineKeys = Object.keys(defines).sort();
      var injectKeys = Object.keys(inject).sort();
      var defineHashes = [];
      var injectHashes = [];
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = defineKeys[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var key = _step.value;
          defineHashes.push(this._getHash(key));
          defineHashes.push(this._getHash(defines[key]));
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = injectKeys[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var _key = _step2.value;
          injectHashes.push(this._getHash(_key));
          injectHashes.push(this._getHash(inject[_key]));
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      var hash = "".concat(vsHash, "/").concat(fsHash, "D").concat(defineHashes.join('/'), "M").concat(moduleHashes.join('/'), "I").concat(injectHashes.join('/'), "V").concat(varyingHashes.join('/'), "H").concat(this.stateHash, "B").concat(bufferMode).concat(transpileToGLSL100 ? 'T' : '');

      if (!this._programCache[hash]) {
        var assembled = assembleShaders(this.gl, {
          vs: vs,
          fs: fs,
          modules: modules,
          inject: inject,
          defines: defines,
          hookFunctions: this._hookFunctions,
          transpileToGLSL100: transpileToGLSL100
        });
        this._programCache[hash] = new Program(this.gl, {
          hash: hash,
          vs: assembled.vs,
          fs: assembled.fs,
          varyings: varyings,
          bufferMode: bufferMode
        });

        this._getUniforms[hash] = assembled.getUniforms || function (x) {};

        this._useCounts[hash] = 0;
      }

      this._useCounts[hash]++;
      return this._programCache[hash];
    }
  }, {
    key: "getUniforms",
    value: function getUniforms(program) {
      return this._getUniforms[program.hash] || null;
    }
  }, {
    key: "release",
    value: function release(program) {
      var hash = program.hash;
      this._useCounts[hash]--;

      if (this._useCounts[hash] === 0) {
        this._programCache[hash]["delete"]();

        delete this._programCache[hash];
        delete this._getUniforms[hash];
        delete this._useCounts[hash];
      }
    }
  }, {
    key: "_getHash",
    value: function _getHash(key) {
      if (this._hashes[key] === undefined) {
        this._hashes[key] = this._hashCounter++;
      }

      return this._hashes[key];
    }
  }, {
    key: "_getModuleList",
    value: function _getModuleList() {
      var appModules = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var modules = new Array(this._defaultModules.length + appModules.length);
      var seen = {};
      var count = 0;

      for (var i = 0, len = this._defaultModules.length; i < len; ++i) {
        var module = this._defaultModules[i];
        var name = module.name;
        modules[count++] = module;
        seen[name] = true;
      }

      for (var _i = 0, _len = appModules.length; _i < _len; ++_i) {
        var _module = appModules[_i];
        var _name = _module.name;

        if (!seen[_name]) {
          modules[count++] = _module;
          seen[_name] = true;
        }
      }

      modules.length = count;
      return modules;
    }
  }]);

  return ProgramManager;
}();

export { ProgramManager as default };
//# sourceMappingURL=program-manager.js.map