import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { isWebGL2 } from '@luma.gl/gltools';
import { Buffer, TransformFeedback } from '@luma.gl/webgl';
import { assert } from '@luma.gl/webgl';

var BufferTransform = function () {
  function BufferTransform(gl) {
    var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, BufferTransform);

    this.gl = gl;
    this.currentIndex = 0;
    this.feedbackMap = {};
    this.varyings = null;
    this.bindings = [];
    this.resources = {};

    this._initialize(props);

    Object.seal(this);
  }

  _createClass(BufferTransform, [{
    key: "setupResources",
    value: function setupResources(opts) {
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this.bindings[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var binding = _step.value;

          this._setupTransformFeedback(binding, opts);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: "updateModelProps",
    value: function updateModelProps() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var varyings = this.varyings;

      if (varyings.length > 0) {
        props = Object.assign({}, props, {
          varyings: varyings
        });
      }

      return props;
    }
  }, {
    key: "getDrawOptions",
    value: function getDrawOptions() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var binding = this.bindings[this.currentIndex];
      var sourceBuffers = binding.sourceBuffers,
          transformFeedback = binding.transformFeedback;
      var attributes = Object.assign({}, sourceBuffers, opts.attributes);
      return {
        attributes: attributes,
        transformFeedback: transformFeedback
      };
    }
  }, {
    key: "swap",
    value: function swap() {
      if (this.feedbackMap) {
        this.currentIndex = this._getNextIndex();
        return true;
      }

      return false;
    }
  }, {
    key: "update",
    value: function update() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      this._setupBuffers(opts);
    }
  }, {
    key: "getBuffer",
    value: function getBuffer(varyingName) {
      var feedbackBuffers = this.bindings[this.currentIndex].feedbackBuffers;
      var bufferOrParams = varyingName ? feedbackBuffers[varyingName] : null;

      if (!bufferOrParams) {
        return null;
      }

      return bufferOrParams instanceof Buffer ? bufferOrParams : bufferOrParams.buffer;
    }
  }, {
    key: "getData",
    value: function getData() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          varyingName = _ref.varyingName;

      var buffer = this.getBuffer(varyingName);

      if (buffer) {
        return buffer.getData();
      }

      return null;
    }
  }, {
    key: "delete",
    value: function _delete() {
      for (var name in this.resources) {
        this.resources[name]["delete"]();
      }
    }
  }, {
    key: "_initialize",
    value: function _initialize() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      this._setupBuffers(props);

      this.varyings = props.varyings || Object.keys(this.bindings[this.currentIndex].feedbackBuffers);

      if (this.varyings.length > 0) {
        assert(isWebGL2(this.gl));
      }
    }
  }, {
    key: "_getFeedbackBuffers",
    value: function _getFeedbackBuffers(props) {
      var _props$sourceBuffers = props.sourceBuffers,
          sourceBuffers = _props$sourceBuffers === void 0 ? {} : _props$sourceBuffers;
      var feedbackBuffers = {};

      if (this.bindings[this.currentIndex]) {
        Object.assign(feedbackBuffers, this.bindings[this.currentIndex].feedbackBuffers);
      }

      if (this.feedbackMap) {
        for (var sourceName in this.feedbackMap) {
          var feedbackName = this.feedbackMap[sourceName];

          if (sourceName in sourceBuffers) {
            feedbackBuffers[feedbackName] = sourceName;
          }
        }
      }

      Object.assign(feedbackBuffers, props.feedbackBuffers);

      for (var bufferName in feedbackBuffers) {
        var bufferOrRef = feedbackBuffers[bufferName];

        if (typeof bufferOrRef === 'string') {
          var sourceBuffer = sourceBuffers[bufferOrRef];
          var byteLength = sourceBuffer.byteLength,
              usage = sourceBuffer.usage,
              accessor = sourceBuffer.accessor;
          feedbackBuffers[bufferName] = this._createNewBuffer(bufferName, {
            byteLength: byteLength,
            usage: usage,
            accessor: accessor
          });
        }
      }

      return feedbackBuffers;
    }
  }, {
    key: "_setupBuffers",
    value: function _setupBuffers() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _props$sourceBuffers2 = props.sourceBuffers,
          sourceBuffers = _props$sourceBuffers2 === void 0 ? null : _props$sourceBuffers2;
      Object.assign(this.feedbackMap, props.feedbackMap);

      var feedbackBuffers = this._getFeedbackBuffers(props);

      this._updateBindings({
        sourceBuffers: sourceBuffers,
        feedbackBuffers: feedbackBuffers
      });
    }
  }, {
    key: "_setupTransformFeedback",
    value: function _setupTransformFeedback(binding, _ref2) {
      var model = _ref2.model;
      var program = model.program;
      binding.transformFeedback = new TransformFeedback(this.gl, {
        program: program,
        buffers: binding.feedbackBuffers
      });
    }
  }, {
    key: "_updateBindings",
    value: function _updateBindings(opts) {
      this.bindings[this.currentIndex] = this._updateBinding(this.bindings[this.currentIndex], opts);

      if (this.feedbackMap) {
        var _this$_swapBuffers = this._swapBuffers(this.bindings[this.currentIndex]),
            sourceBuffers = _this$_swapBuffers.sourceBuffers,
            feedbackBuffers = _this$_swapBuffers.feedbackBuffers;

        var nextIndex = this._getNextIndex();

        this.bindings[nextIndex] = this._updateBinding(this.bindings[nextIndex], {
          sourceBuffers: sourceBuffers,
          feedbackBuffers: feedbackBuffers
        });
      }
    }
  }, {
    key: "_updateBinding",
    value: function _updateBinding(binding, opts) {
      if (!binding) {
        return {
          sourceBuffers: Object.assign({}, opts.sourceBuffers),
          feedbackBuffers: Object.assign({}, opts.feedbackBuffers)
        };
      }

      Object.assign(binding.sourceBuffers, opts.sourceBuffers);
      Object.assign(binding.feedbackBuffers, opts.feedbackBuffers);

      if (binding.transformFeedback) {
        binding.transformFeedback.setBuffers(binding.feedbackBuffers);
      }

      return binding;
    }
  }, {
    key: "_swapBuffers",
    value: function _swapBuffers(opts) {
      if (!this.feedbackMap) {
        return null;
      }

      var sourceBuffers = Object.assign({}, opts.sourceBuffers);
      var feedbackBuffers = Object.assign({}, opts.feedbackBuffers);

      for (var srcName in this.feedbackMap) {
        var dstName = this.feedbackMap[srcName];
        sourceBuffers[srcName] = opts.feedbackBuffers[dstName];
        feedbackBuffers[dstName] = opts.sourceBuffers[srcName];
        assert(feedbackBuffers[dstName] instanceof Buffer);
      }

      return {
        sourceBuffers: sourceBuffers,
        feedbackBuffers: feedbackBuffers
      };
    }
  }, {
    key: "_createNewBuffer",
    value: function _createNewBuffer(name, opts) {
      var buffer = new Buffer(this.gl, opts);

      if (this.resources[name]) {
        this.resources[name]["delete"]();
      }

      this.resources[name] = buffer;
      return buffer;
    }
  }, {
    key: "_getNextIndex",
    value: function _getNextIndex() {
      return (this.currentIndex + 1) % 2;
    }
  }]);

  return BufferTransform;
}();

export { BufferTransform as default };
//# sourceMappingURL=buffer-transform.js.map