"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _webgl = require("@luma.gl/webgl");

var _gltools = require("@luma.gl/gltools");

var _engine = require("@luma.gl/engine");

var _textureFilter = _interopRequireDefault(require("./texture-filter"));

var _shaders = require("./shaders");

var Polygon = _interopRequireWildcard(require("./polygon"));

var TEXTURE_SIZE = 512;

var GPUPointInPolygon = function () {
  function GPUPointInPolygon(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2["default"])(this, GPUPointInPolygon);
    this.gl = gl;
    (0, _webgl.assert)((0, _gltools.isWebGL2)(gl));
    this.textureSize = TEXTURE_SIZE;

    this._setupResources();

    this.update(opts);
  }

  (0, _createClass2["default"])(GPUPointInPolygon, [{
    key: "update",
    value: function update() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          polygons = _ref.polygons,
          textureSize = _ref.textureSize;

      if (textureSize) {
        this.textureSize = textureSize;
      }

      if (!polygons || polygons.length === 0) {
        return;
      }

      var _triangulatePolygons = triangulatePolygons(polygons),
          vertices = _triangulatePolygons.vertices,
          indices = _triangulatePolygons.indices,
          vertexCount = _triangulatePolygons.vertexCount,
          ids = _triangulatePolygons.ids;

      this._updateResources(vertices, indices, ids, vertexCount);
    }
  }, {
    key: "filter",
    value: function filter(_ref2) {
      var positionBuffer = _ref2.positionBuffer,
          filterValueIndexBuffer = _ref2.filterValueIndexBuffer,
          count = _ref2.count;
      this.filterTransform.update({
        sourceBuffers: {
          a_position: positionBuffer
        },
        feedbackBuffers: {
          filterValueIndex: filterValueIndexBuffer
        },
        elementCount: count
      });
      var polygonTexture = this.polygonTexture,
          boundingBox = this.boundingBox;
      this.filterTransform.run({
        moduleSettings: {
          boundingBox: boundingBox,
          texture: polygonTexture
        }
      });
    }
  }, {
    key: "_setupResources",
    value: function _setupResources() {
      var _parameters;

      var gl = this.gl;
      this.polygonTexture = new _webgl.Texture2D(gl, {
        format: 6407,
        type: 5121,
        dataFormat: 6407,
        border: 0,
        mipmaps: false,
        parameters: (_parameters = {}, (0, _defineProperty2["default"])(_parameters, 10240, 9728), (0, _defineProperty2["default"])(_parameters, 10241, 9728), (0, _defineProperty2["default"])(_parameters, 10242, 33071), (0, _defineProperty2["default"])(_parameters, 10243, 33071), _parameters)
      });
      this.positionBuffer = new _webgl.Buffer(gl, {
        accessor: {
          type: 5126,
          size: 2
        }
      });
      this.idBuffer = new _webgl.Buffer(gl, {
        accessor: {
          type: 5126,
          size: 1
        }
      });
      this.indexBuffer = new _webgl.Buffer(gl, {
        target: 34963,
        accessor: {
          type: 5123
        }
      });
      this.polyTextureTransform = new _engine.Transform(gl, {
        id: "polygon-texture-creation-transform",
        elementCount: 0,
        _targetTexture: this.polygonTexture,
        _targetTextureVarying: 'v_polygonColor',
        vs: _shaders.POLY_TEX_VS,
        drawMode: 4,
        isIndexed: true,
        sourceBuffers: {
          a_position: this.positionBuffer,
          a_polygonID: this.idBuffer,
          indices: this.indexBuffer
        }
      });
      this.filterTransform = new _engine.Transform(gl, {
        id: 'filter transform',
        vs: _shaders.FILTER_VS,
        modules: [_textureFilter["default"]],
        varyings: ['filterValueIndex']
      });
    }
  }, {
    key: "_updateResources",
    value: function _updateResources(vertices, indices, ids, vertexCount) {
      var boundingBox = getBoundingBox(vertices, vertexCount);

      var _boundingBox = (0, _slicedToArray2["default"])(boundingBox, 4),
          xMin = _boundingBox[0],
          yMin = _boundingBox[1],
          xMax = _boundingBox[2],
          yMax = _boundingBox[3];

      var width = xMax - xMin;
      var height = yMax - yMin;
      var whRatio = width / height;
      var textureSize = this.textureSize;
      var texWidth = textureSize;
      var texHeight = textureSize;

      if (whRatio > 1) {
        texHeight = texWidth / whRatio;
      } else {
        texWidth = texHeight * whRatio;
      }

      this.boundingBox = boundingBox;
      this.polygonTexture.resize({
        width: texWidth,
        height: texHeight,
        mipmaps: false
      });
      this.positionBuffer.setData(new Float32Array(vertices));
      this.idBuffer.setData(new Float32Array(ids));
      this.indexBuffer.setData(new Uint16Array(indices));
      this.polyTextureTransform.update({
        elementCount: indices.length,
        _targetTexture: this.polygonTexture
      });
      this.polyTextureTransform.run({
        uniforms: {
          boundingBoxOriginSize: [xMin, yMin, width, height]
        }
      });
    }
  }]);
  return GPUPointInPolygon;
}();

exports["default"] = GPUPointInPolygon;

function getBoundingBox(positions, vertexCount) {
  var yMin = Infinity;
  var yMax = -Infinity;
  var xMin = Infinity;
  var xMax = -Infinity;
  var y;
  var x;

  for (var i = 0; i < vertexCount; i++) {
    x = positions[i * 2];
    y = positions[i * 2 + 1];
    yMin = y < yMin ? y : yMin;
    yMax = y > yMax ? y : yMax;
    xMin = x < xMin ? x : xMin;
    xMax = x > xMax ? x : xMax;
  }

  return [xMin, yMin, xMax, yMax];
}

function triangulatePolygons(polygons) {
  var SIZE = 2;
  var vertices = [];
  var indices = [];
  var ids = [];
  var count = 0;
  var polygonId = 0;

  for (var i = 0; i < polygons.length; i++) {
    var normalized = Polygon.normalize(polygons[i], SIZE);
    var curVertices = normalized.positions || normalized;
    var curCount = curVertices.length / SIZE;
    var curIds = new Array(curCount).fill(polygonId);
    vertices.push.apply(vertices, (0, _toConsumableArray2["default"])(curVertices));
    ids.push.apply(ids, (0, _toConsumableArray2["default"])(curIds));
    var curIndices = Polygon.getSurfaceIndices(normalized, SIZE);
    var indexCount = curIndices.length;

    for (var j = 0; j < indexCount; j++) {
      curIndices[j] += count;
    }

    count += curCount;
    indices.push.apply(indices, (0, _toConsumableArray2["default"])(curIndices));
    polygonId++;
  }

  (0, _webgl.assert)(count < 65536);
  var vertexCount = Polygon.getVertexCount(vertices, SIZE);
  return {
    vertices: vertices,
    indices: indices,
    ids: ids,
    vertexCount: vertexCount
  };
}
//# sourceMappingURL=gpu-point-in-polygon.js.map