import { Texture2D, TextureCube } from '@luma.gl/webgl';
import { loadImage } from '@loaders.gl/images';
export default class GLTFEnvironment {
  constructor(gl, {
    brdfLutUrl,
    getTexUrl,
    specularMipLevels = 10
  }) {
    this.gl = gl;
    this.brdfLutUrl = brdfLutUrl;
    this.getTexUrl = getTexUrl;
    this.specularMipLevels = specularMipLevels;
  }

  makeCube({
    id,
    getTextureForFace,
    parameters
  }) {
    const pixels = {};
    TextureCube.FACES.forEach(face => {
      pixels[face] = getTextureForFace(face);
    });
    return new TextureCube(this.gl, {
      id,
      mipmaps: false,
      parameters,
      pixels
    });
  }

  getDiffuseEnvSampler() {
    if (!this._DiffuseEnvSampler) {
      this._DiffuseEnvSampler = this.makeCube({
        id: 'DiffuseEnvSampler',
        getTextureForFace: dir => loadImage(this.getTexUrl('diffuse', dir, 0)),
        parameters: {
          [10242]: 33071,
          [10243]: 33071,
          [10241]: 9729,
          [10240]: 9729
        }
      });
    }

    return this._DiffuseEnvSampler;
  }

  getSpecularEnvSampler() {
    if (!this._SpecularEnvSampler) {
      this._SpecularEnvSampler = this.makeCube({
        id: 'SpecularEnvSampler',
        getTextureForFace: dir => {
          const imageArray = [];

          for (let lod = 0; lod <= this.specularMipLevels - 1; lod++) {
            imageArray.push(loadImage(this.getTexUrl('specular', dir, lod)));
          }

          return imageArray;
        },
        parameters: {
          [10242]: 33071,
          [10243]: 33071,
          [10241]: 9987,
          [10240]: 9729
        }
      });
    }

    return this._SpecularEnvSampler;
  }

  getBrdfTexture() {
    if (!this._BrdfTexture) {
      this._BrdfTexture = new Texture2D(this.gl, {
        id: 'brdfLUT',
        parameters: {
          [10242]: 33071,
          [10243]: 33071,
          [10241]: 9729,
          [10240]: 9729
        },
        data: loadImage(this.brdfLutUrl)
      });
    }

    return this._BrdfTexture;
  }

  delete() {
    if (this._DiffuseEnvSampler) {
      this._DiffuseEnvSampler.delete();

      this._DiffuseEnvSampler = null;
    }

    if (this._SpecularEnvSampler) {
      this._SpecularEnvSampler.delete();

      this._SpecularEnvSampler = null;
    }

    if (this._BrdfTexture) {
      this._BrdfTexture.delete();

      this._BrdfTexture = null;
    }
  }

}
//# sourceMappingURL=gltf-environment.js.map