const vs = "\nuniform vec4 textureFilter_uBoundingBox; //[xMin, yMin, xSize, ySize]\nuniform sampler2D textureFilter_uTexture;\nvec2 textureFilter_filter(vec2 position) {\n  vec2 filterValueIndex;\n  // Transfrom 'pos' to texture coordinate\n  vec2 pos = position - textureFilter_uBoundingBox.xy;\n  pos = pos / textureFilter_uBoundingBox.zw;\n  filterValueIndex.y = float(gl_VertexID);\n  if (pos.x < 0. || pos.x > 1. || pos.y < 0. || pos.y > 1.) {\n    filterValueIndex.x = -1.;\n  } else {\n    // Red channel is ID, Green channel inside/outside polygon\n    vec4 color = texture(textureFilter_uTexture, pos.xy);\n    filterValueIndex.x = color.g > 0. ? color.r : -1.;\n  }\n  return filterValueIndex;\n}\n";

function getUniforms(opts = {}) {
  const uniforms = {};

  if (opts.boundingBox) {
    const [xMin, yMin, xMax, yMax] = opts.boundingBox;
    uniforms.textureFilter_uBoundingBox = [xMin, yMin, xMax - xMin, yMax - yMin];
  }

  if (opts.texture) {
    uniforms.textureFilter_uTexture = opts.texture;
  }

  return uniforms;
}

export default {
  name: 'texture-filter',
  vs,
  getUniforms
};
//# sourceMappingURL=texture-filter.js.map