import { Model } from '@luma.gl/engine';
import ScenegraphNode from './scenegraph-node';
export default class ModelNode extends ScenegraphNode {
  constructor(gl, props = {}) {
    super(props);
    this.onBeforeRender = null;
    this.AfterRender = null;

    if (gl instanceof Model) {
      this.model = gl;

      this._setModelNodeProps(props);
    } else {
      this.model = new Model(gl, props);
    }

    this.managedResources = props.managedResources || [];
  }

  setProps(props) {
    super.setProps(props);

    this._setModelNodeProps(props);

    return this;
  }

  delete() {
    if (this.model) {
      this.model.delete();
      this.model = null;
    }

    this.managedResources.forEach(resource => resource.delete());
    this.managedResources = [];
  }

  draw(...args) {
    return this.model.draw(...args);
  }

  setUniforms(...args) {
    this.model.setUniforms(...args);
    return this;
  }

  setAttributes(...args) {
    this.model.setAttributes(...args);
    return this;
  }

  updateModuleSettings(...args) {
    this.model.updateModuleSettings(...args);
    return this;
  }

  _setModelNodeProps(props) {
    this.model.setProps(props);
  }

}
//# sourceMappingURL=model-node.js.map