import _objectSpread from "@babel/runtime/helpers/esm/objectSpread";
import { withParameters } from '@luma.gl/gltools';
export default class Display {
  getViews(options) {
    const {
      width,
      height
    } = options;
    return [{
      params: {
        viewport: [0, 0, width, height],
        scissor: [0, 0, width, height],
        scissorTest: true
      }
    }];
  }

  submitFrame() {
    return true;
  }

  requestAnimationFrame(renderFrame) {
    return false;
  }

  delete() {}

  _renderFrame(options) {
    const views = this.getViews(options);

    if (!views) {
      return false;
    }

    const {
      gl
    } = this.animationLoop;

    for (const view of views) {
      withParameters(gl, view.params, () => this.animationLoop.onRender(_objectSpread({}, options, view)));
    }

    this.submitFrame();
    return true;
  }

}
//# sourceMappingURL=display.js.map