import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { Texture2D, hasFeature, FEATURES, log } from '@luma.gl/webgl';

var GLTFMaterialParser = function () {
  function GLTFMaterialParser(gl, _ref) {
    var attributes = _ref.attributes,
        material = _ref.material,
        pbrDebug = _ref.pbrDebug,
        imageBasedLightingEnvironment = _ref.imageBasedLightingEnvironment,
        lights = _ref.lights,
        useTangents = _ref.useTangents;

    _classCallCheck(this, GLTFMaterialParser);

    this.gl = gl;
    this.defines = {
      MANUAL_SRGB: 1,
      SRGB_FAST_APPROXIMATION: 1
    };

    if (hasFeature(gl, FEATURES.GLSL_TEXTURE_LOD)) {
      this.defines.USE_TEX_LOD = 1;
    }

    this.uniforms = {
      u_Camera: [0, 0, 0],
      u_MetallicRoughnessValues: [1, 1]
    };
    this.parameters = {};
    this.generatedTextures = [];

    if (imageBasedLightingEnvironment) {
      this.uniforms.u_DiffuseEnvSampler = imageBasedLightingEnvironment.getDiffuseEnvSampler();
      this.uniforms.u_SpecularEnvSampler = imageBasedLightingEnvironment.getSpecularEnvSampler();
      this.uniforms.u_brdfLUT = imageBasedLightingEnvironment.getBrdfTexture();
      this.uniforms.u_ScaleIBLAmbient = [1, 1];
    }

    if (pbrDebug) {
      this.uniforms.u_ScaleDiffBaseMR = [0, 0, 0, 0];
      this.uniforms.u_ScaleFGDSpec = [0, 0, 0, 0];
    }

    this.defineIfPresent(attributes.NORMAL, 'HAS_NORMALS');
    this.defineIfPresent(attributes.TANGENT && useTangents, 'HAS_TANGENTS');
    this.defineIfPresent(attributes.TEXCOORD_0, 'HAS_UV');
    this.defineIfPresent(imageBasedLightingEnvironment, 'USE_IBL');
    this.defineIfPresent(lights, 'USE_LIGHTS');
    this.defineIfPresent(pbrDebug, 'PBR_DEBUG');

    if (material) {
      this.parseMaterial(material);
    }
  }

  _createClass(GLTFMaterialParser, [{
    key: "defineIfPresent",
    value: function defineIfPresent(value, name) {
      if (value) {
        this.defines[name] = 1;
      }
    }
  }, {
    key: "parseTexture",
    value: function parseTexture(gltfTexture, name) {
      var define = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      var parameters = gltfTexture.texture && gltfTexture.texture.sampler && gltfTexture.texture.sampler.parameters || {};
      var texture = new Texture2D(this.gl, {
        id: gltfTexture.name || gltfTexture.id,
        parameters: parameters,
        pixelStore: _defineProperty({}, this.gl.UNPACK_FLIP_Y_WEBGL, false),
        data: gltfTexture.texture.source.image
      });
      this.uniforms[name] = texture;
      this.defineIfPresent(define, define);
      this.generatedTextures.push(texture);
    }
  }, {
    key: "parsePbrMetallicRoughness",
    value: function parsePbrMetallicRoughness(pbrMetallicRoughness) {
      if (pbrMetallicRoughness.baseColorTexture) {
        this.parseTexture(pbrMetallicRoughness.baseColorTexture, 'u_BaseColorSampler', 'HAS_BASECOLORMAP');
      }

      this.uniforms.u_BaseColorFactor = pbrMetallicRoughness.baseColorFactor || [1, 1, 1, 1];

      if (pbrMetallicRoughness.metallicRoughnessTexture) {
        this.parseTexture(pbrMetallicRoughness.metallicRoughnessTexture, 'u_MetallicRoughnessSampler', 'HAS_METALROUGHNESSMAP');
      }

      var _pbrMetallicRoughness = pbrMetallicRoughness.metallicFactor,
          metallicFactor = _pbrMetallicRoughness === void 0 ? 1 : _pbrMetallicRoughness,
          _pbrMetallicRoughness2 = pbrMetallicRoughness.roughnessFactor,
          roughnessFactor = _pbrMetallicRoughness2 === void 0 ? 1 : _pbrMetallicRoughness2;
      this.uniforms.u_MetallicRoughnessValues = [metallicFactor, roughnessFactor];
    }
  }, {
    key: "parseMaterial",
    value: function parseMaterial(material) {
      if (material.pbrMetallicRoughness) {
        this.parsePbrMetallicRoughness(material.pbrMetallicRoughness);
      }

      if (material.normalTexture) {
        this.parseTexture(material.normalTexture, 'u_NormalSampler', 'HAS_NORMALMAP');
        var _material$normalTextu = material.normalTexture.scale,
            scale = _material$normalTextu === void 0 ? 1 : _material$normalTextu;
        this.uniforms.u_NormalScale = scale;
      }

      if (material.occlusionTexture) {
        this.parseTexture(material.occlusionTexture, 'u_OcclusionSampler', 'HAS_OCCLUSIONMAP');
        var _material$occlusionTe = material.occlusionTexture.strength,
            strength = _material$occlusionTe === void 0 ? 1 : _material$occlusionTe;
        this.uniforms.u_OcclusionStrength = strength;
      }

      if (material.emissiveTexture) {
        this.parseTexture(material.emissiveTexture, 'u_EmissiveSampler', 'HAS_EMISSIVEMAP');
        this.uniforms.u_EmissiveFactor = material.emissiveFactor || [0, 0, 0];
      }

      if (material.alphaMode === 'MASK') {
        var _material$alphaCutoff = material.alphaCutoff,
            alphaCutoff = _material$alphaCutoff === void 0 ? 0.5 : _material$alphaCutoff;
        this.defines.ALPHA_CUTOFF = 1;
        this.uniforms.u_AlphaCutoff = alphaCutoff;
      } else if (material.alphaMode === 'BLEND') {
        log.warn('BLEND alphaMode might not work well because it requires mesh sorting')();
        Object.assign(this.parameters, {
          blend: true,
          blendEquation: this.gl.FUNC_ADD,
          blendFunc: [this.gl.SRC_ALPHA, this.gl.ONE_MINUS_SRC_ALPHA, this.gl.ONE, this.gl.ONE_MINUS_SRC_ALPHA]
        });
      }
    }
  }]);

  return GLTFMaterialParser;
}();

export { GLTFMaterialParser as default };
//# sourceMappingURL=gltf-material-parser.js.map