"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FILTER_VS = exports.POLY_TEX_VS = void 0;
var POLY_TEX_VS = "uniform vec4 boundingBoxOriginSize; //[xMin, yMin, xSize, ySize]\nattribute vec2 a_position;\nattribute float a_polygonID;\nvarying vec4 v_polygonColor;\nvoid main()\n{\n    // translate from bbox to NDC\n    vec2 pos = a_position - boundingBoxOriginSize.xy;\n    pos = pos / boundingBoxOriginSize.zw;\n    pos = pos * 2.0 - vec2(1.0);\n    gl_Position = vec4(pos, 0.0, 1.0);\n    v_polygonColor = vec4(a_polygonID, 1.0, 1.0, 1.0);\n}\n";
exports.POLY_TEX_VS = POLY_TEX_VS;
var FILTER_VS = "#version 300 es\nin vec2 a_position;\nout vec2 filterValueIndex; //[x: 0 (outside polygon)/1 (inside), y: position index]\nvoid main()\n{\n  filterValueIndex = textureFilter_filter(a_position);\n}\n";
exports.FILTER_VS = FILTER_VS;
//# sourceMappingURL=shaders.js.map