export const HISTOPYRAMID_BUILD_VS_UTILS = "// Get current pixel indices for a given size\nvec2 histoPyramid_getPixelIndices(vec2 size) {\n  vec2 pixelOffset = transform_getPixelSizeHalf(size);\n  vec2 pixelIndices = transform_getPixelIndices(size, pixelOffset);\n  return pixelIndices;\n}\n\n// returns the top left texture coordiante corresponding to 2X2 block in higher level texture.\n// size: lower level texture size\n// scale: usually (2, 2)\n// offset: offset with-in 2X2 block of higher level texture\nvec2 histoPyramid_getTexCoord(vec2 size, vec2 scale, vec2 offset) {\n  // use actual (scaled) texture size to calcualte offset (multiplied by scale)\n  vec2 scaledSize = size * scale;\n\n  // use minified texture size to find corresponding pixel index in out texture\n  vec2 pixelIndices = histoPyramid_getPixelIndices(size);\n\n  // now scale the indices to point to correct 2X2 block\n  pixelIndices = pixelIndices * scale;\n\n  // generate tex coordinate using actual size\n  vec2 texCoord = pixelIndices / scaledSize;\n  vec2 inPixelOffset = transform_getPixelSizeHalf(scaledSize);\n\n  return texCoord + (offset / scaledSize) + inPixelOffset;\n}\n\n// returns pixel value from higher level texture based on scale and offset\n// texSampler: higher level texture sampler\n// size: lower level texture size\n// scale: usually (2, 2)\n// offset: offset with-in 2X2 block of higher level texture\nvec4 histoPyramid_getInput(sampler2D texSampler, vec2 size, vec2 scale, vec2 offset) {\n  vec2 texCoord = histoPyramid_getTexCoord(size, scale, offset);\n  vec4 textureColor = texture2D(texSampler, texCoord);\n  return textureColor;\n}\n";
export const HISTOPYRAMID_BUILD_VS = "attribute vec4 inTexture;\nvarying vec4 outTexture;\n\nvoid main()\n{\n  vec2 size = transform_uSize_outTexture;\n  vec2 scale = vec2(2., 2.);\n  vec4 pixel = histoPyramid_getInput(transform_uSampler_inTexture, size, scale, vec2(0, 0));\n  vec4 rightPixel = histoPyramid_getInput(transform_uSampler_inTexture, size, scale, vec2(1, 0));\n  vec4 bottomPixel = histoPyramid_getInput(transform_uSampler_inTexture, size, scale, vec2(0, 1));\n  vec4 rightBottomPixel = histoPyramid_getInput(transform_uSampler_inTexture, size, scale, vec2(1, 1));\n  // outTexture = pixel + rightPixel + bottomPixel + rightBottomPixel;\n  outTexture = vec4(\n    pixel.r + pixel.g + pixel.b + pixel.a,\n    rightPixel.r + rightPixel.g + rightPixel.b + rightPixel.a,\n    bottomPixel.r + bottomPixel.g + bottomPixel.b + bottomPixel.a,\n    rightBottomPixel.r + rightBottomPixel.g + rightBottomPixel.b + rightBottomPixel.a\n  );\n}\n";
export const HISTOPYRAMID_BASE_BUILD_VS = "attribute vec4 inTexture;\nvarying vec4 outTexture;\nuniform int channel;\nuniform vec4 padingPixelValue;\n\nvoid main()\n{\n  vec2 size = transform_uSize_outTexture;\n  // vec2 scale = vec2(2., 2.);\n  vec2 scale = transform_uSize_inTexture / transform_uSize_outTexture;\n\n  // Verify if reference to a input texture pixel is out of bounds, if so treat the pixel as (0, 0)\n  vec2 pixelIndices = histoPyramid_getPixelIndices(size);\n  // now scale the indices padded size to point to correct 2X2 block\n  pixelIndices = pixelIndices * vec2(2, 2);\n\n  vec2 baseLevelSize = transform_uSize_inTexture;\n\n  // For all pixels outside of original texture size, return paddingPixelValue\n  bool xInside = pixelIndices.x < baseLevelSize.x;\n  bool yInside = pixelIndices.y < baseLevelSize.y;\n  bool xPlusOneInside = pixelIndices.x + 1. < baseLevelSize.x;\n  bool yPlusOneInside = pixelIndices.y + 1. < baseLevelSize.y;\n\n  vec4 pixel = (xInside && yInside)\n    ? histoPyramid_getInput(transform_uSampler_inTexture, size, scale, vec2(0, 0))\n    : padingPixelValue;\n\n  vec4 rightPixel = (xPlusOneInside && yInside)\n    ? histoPyramid_getInput(transform_uSampler_inTexture, size, scale, vec2(1, 0))\n    : padingPixelValue;\n\n  vec4 topPixel = (xInside && yPlusOneInside)\n    ? histoPyramid_getInput(transform_uSampler_inTexture, size, scale, vec2(0, 1))\n    : padingPixelValue;\n\n  vec4 rightTopPixel = (xPlusOneInside && yPlusOneInside)\n    ? histoPyramid_getInput(transform_uSampler_inTexture, size, scale, vec2(1, 1))\n    : padingPixelValue;\n\n  if (channel == 0) {\n    outTexture = vec4(pixel.r, rightPixel.r, topPixel.r, rightTopPixel.r);\n  }\n  if (channel == 1) {\n    outTexture = vec4(pixel.g, rightPixel.g, topPixel.g, rightTopPixel.g);\n  }\n  if (channel == 2) {\n    outTexture = vec4(pixel.b, rightPixel.b, topPixel.b, rightTopPixel.b);\n  }\n  if (channel == 3) {\n    outTexture = vec4(pixel.a, rightPixel.a, topPixel.a, rightTopPixel.a);\n  }\n}\n";
export const HISTOPYRAMID_TRAVERSAL_UTILS = "// Check 2X2 texture block to find relative index the given key index falls into\n// 2X2 block is represented by a single RGBA weight\nint histopyramid_traversal_findRangeIndex(float currentKey, vec4 weights, out float lowerBound) {\n  lowerBound = 0.;\n  float higherBound = 0.;\n  int relativeIndex = 0;\n  for (int i = 0; i < 4; i++) {\n    higherBound = lowerBound + weights[i];\n    relativeIndex = i;\n    if (currentKey >= lowerBound && currentKey < higherBound) {\n      break;\n    }\n    lowerBound = higherBound;\n  }\n  return relativeIndex;\n}\n\n// Maps index in 2X2 block to texture coordiante\n// Assumes the traversal order of lower-left -> lower->right -> upper-left -> upper->right\nvec2 histopyramid_traversal_mapIndexToCoord(int index) {\n  // relativeIndex ->  relativeCoordiante\n  // 0 -> (0, 0)\n  // 1 -> (1, 0)\n  // 2 -> (0, 1)\n  // 3 -> (1, 1)\n  float relativeX = mod(float(index), 2.);\n  float relativeY = (index > 1) ? 1. : 0.;\n  return vec2(relativeX, relativeY);\n}\n\n// Reads weight value from flat histopyramid\nvec4 histopyramid_traversal_getWeight(sampler2D flatPyramid, vec2 size, int level, int numLevels, vec2 offset) {\n  // horizontal offset in flat pyramid for current level\n  float xOffset = pow(2., float(numLevels)) - pow(2., float(numLevels - level));\n  vec2 lowerLeft = vec2(xOffset, 0.);\n  vec2 pixelIndices = lowerLeft + offset;\n\n  vec2 pixelSizeHalf = transform_getPixelSizeHalf(size);\n  vec2 coord = pixelIndices / size + pixelSizeHalf;\n\n  return texture2D(flatPyramid, coord);\n}\n";
export const HISTOPYRAMID_TRAVERSAL_VS = "attribute float keyIndex;\nattribute vec4 flatPyramidTexture;\nvarying vec4 locationAndIndex;\nconst int MAX_LEVELS = 12; // assuming max texture size of 4K\n\nuniform int numLevels;\n\nvoid main()\n{\n  vec2 p = vec2(0., 0.);\n  float currentKey = keyIndex;\n  // for(int level = numLevels - 1; level <= 0; level--) {\n  for(int i = 1; i <= MAX_LEVELS; i++) {\n    int level = numLevels - i;\n    // #1. Get the current pixel values based on current level and current p\n    vec4 weights = histopyramid_traversal_getWeight(transform_uSampler_flatPyramidTexture, transform_uSize_flatPyramidTexture, level, numLevels, p);\n\n    // #2. Check the all weights in current 2X2 (4 values in RGBA channels) and determine the relative coordinate\n    float lowerBound = 0.;\n    int relativeIndex = histopyramid_traversal_findRangeIndex(currentKey, weights, lowerBound);\n    vec2 relativeCoord = histopyramid_traversal_mapIndexToCoord(relativeIndex);\n\n    //#3. Update P and key-index\n    p = 2.0 * p + relativeCoord;\n    currentKey -= lowerBound;\n    if (level == 0) { break; } // Work around for const expression restriction on for loops\n  }\n  locationAndIndex = vec4(p, currentKey, keyIndex);\n}\n";
//# sourceMappingURL=histopyramid-shaders.js.map