import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { Buffer, Texture2D, assert } from '@luma.gl/webgl';
import { isWebGL2 } from '@luma.gl/gltools';
import { Transform } from '@luma.gl/engine';
import { default as textureFilterModule } from './texture-filter';
import { POLY_TEX_VS, FILTER_VS } from './shaders';
import * as Polygon from './polygon';
var TEXTURE_SIZE = 512;

var GPUPointInPolygon = function () {
  function GPUPointInPolygon(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, GPUPointInPolygon);

    this.gl = gl;
    assert(isWebGL2(gl));
    this.textureSize = TEXTURE_SIZE;

    this._setupResources();

    this.update(opts);
  }

  _createClass(GPUPointInPolygon, [{
    key: "update",
    value: function update() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          polygons = _ref.polygons,
          textureSize = _ref.textureSize;

      if (textureSize) {
        this.textureSize = textureSize;
      }

      if (!polygons || polygons.length === 0) {
        return;
      }

      var _triangulatePolygons = triangulatePolygons(polygons),
          vertices = _triangulatePolygons.vertices,
          indices = _triangulatePolygons.indices,
          vertexCount = _triangulatePolygons.vertexCount,
          ids = _triangulatePolygons.ids;

      this._updateResources(vertices, indices, ids, vertexCount);
    }
  }, {
    key: "filter",
    value: function filter(_ref2) {
      var positionBuffer = _ref2.positionBuffer,
          filterValueIndexBuffer = _ref2.filterValueIndexBuffer,
          count = _ref2.count;
      this.filterTransform.update({
        sourceBuffers: {
          a_position: positionBuffer
        },
        feedbackBuffers: {
          filterValueIndex: filterValueIndexBuffer
        },
        elementCount: count
      });
      var polygonTexture = this.polygonTexture,
          boundingBox = this.boundingBox;
      this.filterTransform.run({
        moduleSettings: {
          boundingBox: boundingBox,
          texture: polygonTexture
        }
      });
    }
  }, {
    key: "_setupResources",
    value: function _setupResources() {
      var _parameters;

      var gl = this.gl;
      this.polygonTexture = new Texture2D(gl, {
        format: 6407,
        type: 5121,
        dataFormat: 6407,
        border: 0,
        mipmaps: false,
        parameters: (_parameters = {}, _defineProperty(_parameters, 10240, 9728), _defineProperty(_parameters, 10241, 9728), _defineProperty(_parameters, 10242, 33071), _defineProperty(_parameters, 10243, 33071), _parameters)
      });
      this.positionBuffer = new Buffer(gl, {
        accessor: {
          type: 5126,
          size: 2
        }
      });
      this.idBuffer = new Buffer(gl, {
        accessor: {
          type: 5126,
          size: 1
        }
      });
      this.indexBuffer = new Buffer(gl, {
        target: 34963,
        accessor: {
          type: 5123
        }
      });
      this.polyTextureTransform = new Transform(gl, {
        id: "polygon-texture-creation-transform",
        elementCount: 0,
        _targetTexture: this.polygonTexture,
        _targetTextureVarying: 'v_polygonColor',
        vs: POLY_TEX_VS,
        drawMode: 4,
        isIndexed: true,
        sourceBuffers: {
          a_position: this.positionBuffer,
          a_polygonID: this.idBuffer,
          indices: this.indexBuffer
        }
      });
      this.filterTransform = new Transform(gl, {
        id: 'filter transform',
        vs: FILTER_VS,
        modules: [textureFilterModule],
        varyings: ['filterValueIndex']
      });
    }
  }, {
    key: "_updateResources",
    value: function _updateResources(vertices, indices, ids, vertexCount) {
      var boundingBox = getBoundingBox(vertices, vertexCount);

      var _boundingBox = _slicedToArray(boundingBox, 4),
          xMin = _boundingBox[0],
          yMin = _boundingBox[1],
          xMax = _boundingBox[2],
          yMax = _boundingBox[3];

      var width = xMax - xMin;
      var height = yMax - yMin;
      var whRatio = width / height;
      var textureSize = this.textureSize;
      var texWidth = textureSize;
      var texHeight = textureSize;

      if (whRatio > 1) {
        texHeight = texWidth / whRatio;
      } else {
        texWidth = texHeight * whRatio;
      }

      this.boundingBox = boundingBox;
      this.polygonTexture.resize({
        width: texWidth,
        height: texHeight,
        mipmaps: false
      });
      this.positionBuffer.setData(new Float32Array(vertices));
      this.idBuffer.setData(new Float32Array(ids));
      this.indexBuffer.setData(new Uint16Array(indices));
      this.polyTextureTransform.update({
        elementCount: indices.length,
        _targetTexture: this.polygonTexture
      });
      this.polyTextureTransform.run({
        uniforms: {
          boundingBoxOriginSize: [xMin, yMin, width, height]
        }
      });
    }
  }]);

  return GPUPointInPolygon;
}();

export { GPUPointInPolygon as default };

function getBoundingBox(positions, vertexCount) {
  var yMin = Infinity;
  var yMax = -Infinity;
  var xMin = Infinity;
  var xMax = -Infinity;
  var y;
  var x;

  for (var i = 0; i < vertexCount; i++) {
    x = positions[i * 2];
    y = positions[i * 2 + 1];
    yMin = y < yMin ? y : yMin;
    yMax = y > yMax ? y : yMax;
    xMin = x < xMin ? x : xMin;
    xMax = x > xMax ? x : xMax;
  }

  return [xMin, yMin, xMax, yMax];
}

function triangulatePolygons(polygons) {
  var SIZE = 2;
  var vertices = [];
  var indices = [];
  var ids = [];
  var count = 0;
  var polygonId = 0;

  for (var i = 0; i < polygons.length; i++) {
    var normalized = Polygon.normalize(polygons[i], SIZE);
    var curVertices = normalized.positions || normalized;
    var curCount = curVertices.length / SIZE;
    var curIds = new Array(curCount).fill(polygonId);
    vertices.push.apply(vertices, _toConsumableArray(curVertices));
    ids.push.apply(ids, _toConsumableArray(curIds));
    var curIndices = Polygon.getSurfaceIndices(normalized, SIZE);
    var indexCount = curIndices.length;

    for (var j = 0; j < indexCount; j++) {
      curIndices[j] += count;
    }

    count += curCount;
    indices.push.apply(indices, _toConsumableArray(curIndices));
    polygonId++;
  }

  assert(count < 65536);
  var vertexCount = Polygon.getVertexCount(vertices, SIZE);
  return {
    vertices: vertices,
    indices: indices,
    ids: ids,
    vertexCount: vertexCount
  };
}
//# sourceMappingURL=gpu-point-in-polygon.js.map