"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setParameters = setParameters;
exports.getParameters = getParameters;
exports.resetParameters = resetParameters;
exports.withParameters = withParameters;

var _webglParameterTables = require("./webgl-parameter-tables");

var _trackContextState = require("./track-context-state");

var _utils = require("../utils");

function setParameters(gl, values) {
  (0, _utils.assert)((0, _utils.isWebGL)(gl), 'setParameters requires a WebGL context');

  if ((0, _utils.isObjectEmpty)(values)) {
    return;
  }

  var compositeSetters = {};

  for (var key in values) {
    var glConstant = Number(key);
    var setter = _webglParameterTables.GL_PARAMETER_SETTERS[key];

    if (setter) {
      if (typeof setter === 'string') {
        compositeSetters[setter] = true;
      } else {
        setter(gl, values[key], glConstant);
      }
    }
  }

  var cache = gl.state && gl.state.cache;

  if (cache) {
    for (var _key in compositeSetters) {
      var compositeSetter = _webglParameterTables.GL_COMPOSITE_PARAMETER_SETTERS[_key];
      compositeSetter(gl, values, cache);
    }
  }
}

function getParameters(gl, parameters) {
  parameters = parameters || _webglParameterTables.GL_PARAMETER_DEFAULTS;

  if (typeof parameters === 'number') {
    var key = parameters;
    var getter = _webglParameterTables.GL_PARAMETER_GETTERS[key];
    return getter ? getter(gl, key) : gl.getParameter(key);
  }

  var parameterKeys = Array.isArray(parameters) ? parameters : Object.keys(parameters);
  var state = {};
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = parameterKeys[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var _key2 = _step.value;
      var _getter = _webglParameterTables.GL_PARAMETER_GETTERS[_key2];
      state[_key2] = _getter ? _getter(gl, Number(_key2)) : gl.getParameter(Number(_key2));
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return state;
}

function resetParameters(gl) {
  setParameters(gl, _webglParameterTables.GL_PARAMETER_DEFAULTS);
}

function withParameters(gl, parameters, func) {
  if ((0, _utils.isObjectEmpty)(parameters)) {
    return func(gl);
  }

  var _parameters$nocatch = parameters.nocatch,
      nocatch = _parameters$nocatch === void 0 ? true : _parameters$nocatch;
  (0, _trackContextState.pushContextState)(gl);
  setParameters(gl, parameters);
  var value;

  if (nocatch) {
    value = func(gl);
    (0, _trackContextState.popContextState)(gl);
  } else {
    try {
      value = func(gl);
    } finally {
      (0, _trackContextState.popContextState)(gl);
    }
  }

  return value;
}
//# sourceMappingURL=unified-parameter-api.js.map