"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GL_PARAMETER_GETTERS = exports.GL_HOOKED_SETTERS = exports.GL_COMPOSITE_PARAMETER_SETTERS = exports.GL_PARAMETER_SETTERS = exports.GL_PARAMETER_DEFAULTS = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _utils = require("../utils");

var _GL_PARAMETER_DEFAULT, _GL_PARAMETER_SETTERS, _GL_PARAMETER_GETTERS;

var GL_PARAMETER_DEFAULTS = (_GL_PARAMETER_DEFAULT = {}, (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3042, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32773, new Float32Array([0, 0, 0, 0])), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32777, 32774), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 34877, 32774), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32969, 1), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32968, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32971, 1), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32970, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3106, new Float32Array([0, 0, 0, 0])), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3107, [true, true, true, true]), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2884, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2885, 1029), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2929, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2931, 1), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2932, 513), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2928, new Float32Array([0, 1])), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2930, true), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3024, true), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 36006, null), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2886, 2305), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 33170, 4352), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2849, 1), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32823, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32824, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 10752, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32938, 1.0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32939, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3089, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3088, new Int32Array([0, 0, 1024, 1024])), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2960, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2961, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2968, 0xffffffff), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 36005, 0xffffffff), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2962, 519), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2967, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2963, 0xffffffff), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 34816, 519), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 36003, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 36004, 0xffffffff), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2964, 7680), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2965, 7680), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2966, 7680), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 34817, 7680), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 34818, 7680), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 34819, 7680), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 2978, [0, 0, 1024, 1024]), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3333, 4), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3317, 4), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 37440, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 37441, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 37443, 37444), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 35723, 4352), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 36010, null), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 35977, false), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3330, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3332, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3331, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3314, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32878, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3316, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 3315, 0), (0, _defineProperty2["default"])(_GL_PARAMETER_DEFAULT, 32877, 0), _GL_PARAMETER_DEFAULT);
exports.GL_PARAMETER_DEFAULTS = GL_PARAMETER_DEFAULTS;

var enable = function enable(gl, value, key) {
  return value ? gl.enable(key) : gl.disable(key);
};

var hint = function hint(gl, value, key) {
  return gl.hint(key, value);
};

var pixelStorei = function pixelStorei(gl, value, key) {
  return gl.pixelStorei(key, value);
};

var drawFramebuffer = function drawFramebuffer(gl, value) {
  var target = (0, _utils.isWebGL2)(gl) ? 36009 : 36160;
  return gl.bindFramebuffer(target, value);
};

var readFramebuffer = function readFramebuffer(gl, value) {
  return gl.bindFramebuffer(36008, value);
};

function isArray(array) {
  return Array.isArray(array) || ArrayBuffer.isView(array);
}

var GL_PARAMETER_SETTERS = (_GL_PARAMETER_SETTERS = {}, (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3042, enable), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32773, function (gl, value) {
  return gl.blendColor.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32777, 'blendEquation'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 34877, 'blendEquation'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32969, 'blendFunc'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32968, 'blendFunc'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32971, 'blendFunc'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32970, 'blendFunc'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3106, function (gl, value) {
  return gl.clearColor.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3107, function (gl, value) {
  return gl.colorMask.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2884, enable), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2885, function (gl, value) {
  return gl.cullFace(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2929, enable), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2931, function (gl, value) {
  return gl.clearDepth(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2932, function (gl, value) {
  return gl.depthFunc(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2928, function (gl, value) {
  return gl.depthRange.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2930, function (gl, value) {
  return gl.depthMask(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3024, enable), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 35723, hint), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 36006, drawFramebuffer), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2886, function (gl, value) {
  return gl.frontFace(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 33170, hint), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2849, function (gl, value) {
  return gl.lineWidth(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32823, enable), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32824, 'polygonOffset'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 10752, 'polygonOffset'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 35977, enable), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32938, 'sampleCoverage'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32939, 'sampleCoverage'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3089, enable), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3088, function (gl, value) {
  return gl.scissor.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2960, enable), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2961, function (gl, value) {
  return gl.clearStencil(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2968, function (gl, value) {
  return gl.stencilMaskSeparate(1028, value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 36005, function (gl, value) {
  return gl.stencilMaskSeparate(1029, value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2962, 'stencilFuncFront'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2967, 'stencilFuncFront'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2963, 'stencilFuncFront'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 34816, 'stencilFuncBack'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 36003, 'stencilFuncBack'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 36004, 'stencilFuncBack'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2964, 'stencilOpFront'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2965, 'stencilOpFront'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2966, 'stencilOpFront'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 34817, 'stencilOpBack'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 34818, 'stencilOpBack'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 34819, 'stencilOpBack'), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 2978, function (gl, value) {
  return gl.viewport.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3333, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3317, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 37440, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 37441, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 37443, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3330, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3332, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3331, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 36010, readFramebuffer), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3314, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32878, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3316, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 3315, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, 32877, pixelStorei), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "framebuffer", function framebuffer(gl, _framebuffer) {
  var handle = _framebuffer && 'handle' in _framebuffer ? _framebuffer.handle : _framebuffer;
  return gl.bindFramebuffer(36160, handle);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "blend", function blend(gl, value) {
  return value ? gl.enable(3042) : gl.disable(3042);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "blendColor", function blendColor(gl, value) {
  return gl.blendColor.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "blendEquation", function blendEquation(gl, args) {
  args = isArray(args) ? args : [args, args];
  gl.blendEquationSeparate.apply(gl, (0, _toConsumableArray2["default"])(args));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "blendFunc", function blendFunc(gl, args) {
  args = isArray(args) && args.length === 2 ? [].concat((0, _toConsumableArray2["default"])(args), (0, _toConsumableArray2["default"])(args)) : args;
  gl.blendFuncSeparate.apply(gl, (0, _toConsumableArray2["default"])(args));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "clearColor", function clearColor(gl, value) {
  return gl.clearColor.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "clearDepth", function clearDepth(gl, value) {
  return gl.clearDepth(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "clearStencil", function clearStencil(gl, value) {
  return gl.clearStencil(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "colorMask", function colorMask(gl, value) {
  return gl.colorMask.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "cull", function cull(gl, value) {
  return value ? gl.enable(2884) : gl.disable(2884);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "cullFace", function cullFace(gl, value) {
  return gl.cullFace(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "depthTest", function depthTest(gl, value) {
  return value ? gl.enable(2929) : gl.disable(2929);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "depthFunc", function depthFunc(gl, value) {
  return gl.depthFunc(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "depthMask", function depthMask(gl, value) {
  return gl.depthMask(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "depthRange", function depthRange(gl, value) {
  return gl.depthRange.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "dither", function dither(gl, value) {
  return value ? gl.enable(3024) : gl.disable(3024);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "derivativeHint", function derivativeHint(gl, value) {
  gl.hint(35723, value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "frontFace", function frontFace(gl, value) {
  return gl.frontFace(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "mipmapHint", function mipmapHint(gl, value) {
  return gl.hint(33170, value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "lineWidth", function lineWidth(gl, value) {
  return gl.lineWidth(value);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "polygonOffsetFill", function polygonOffsetFill(gl, value) {
  return value ? gl.enable(32823) : gl.disable(32823);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "polygonOffset", function polygonOffset(gl, value) {
  return gl.polygonOffset.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "sampleCoverage", function sampleCoverage(gl, value) {
  return gl.sampleCoverage.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "scissorTest", function scissorTest(gl, value) {
  return value ? gl.enable(3089) : gl.disable(3089);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "scissor", function scissor(gl, value) {
  return gl.scissor.apply(gl, (0, _toConsumableArray2["default"])(value));
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "stencilTest", function stencilTest(gl, value) {
  return value ? gl.enable(2960) : gl.disable(2960);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "stencilMask", function stencilMask(gl, value) {
  value = isArray(value) ? value : [value, value];

  var _value = value,
      _value2 = (0, _slicedToArray2["default"])(_value, 2),
      mask = _value2[0],
      backMask = _value2[1];

  gl.stencilMaskSeparate(1028, mask);
  gl.stencilMaskSeparate(1029, backMask);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "stencilFunc", function stencilFunc(gl, args) {
  args = isArray(args) && args.length === 3 ? [].concat((0, _toConsumableArray2["default"])(args), (0, _toConsumableArray2["default"])(args)) : args;

  var _args = args,
      _args2 = (0, _slicedToArray2["default"])(_args, 6),
      func = _args2[0],
      ref = _args2[1],
      mask = _args2[2],
      backFunc = _args2[3],
      backRef = _args2[4],
      backMask = _args2[5];

  gl.stencilFuncSeparate(1028, func, ref, mask);
  gl.stencilFuncSeparate(1029, backFunc, backRef, backMask);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "stencilOp", function stencilOp(gl, args) {
  args = isArray(args) && args.length === 3 ? [].concat((0, _toConsumableArray2["default"])(args), (0, _toConsumableArray2["default"])(args)) : args;

  var _args3 = args,
      _args4 = (0, _slicedToArray2["default"])(_args3, 6),
      sfail = _args4[0],
      dpfail = _args4[1],
      dppass = _args4[2],
      backSfail = _args4[3],
      backDpfail = _args4[4],
      backDppass = _args4[5];

  gl.stencilOpSeparate(1028, sfail, dpfail, dppass);
  gl.stencilOpSeparate(1029, backSfail, backDpfail, backDppass);
}), (0, _defineProperty2["default"])(_GL_PARAMETER_SETTERS, "viewport", function viewport(gl, value) {
  return gl.viewport.apply(gl, (0, _toConsumableArray2["default"])(value));
}), _GL_PARAMETER_SETTERS);
exports.GL_PARAMETER_SETTERS = GL_PARAMETER_SETTERS;

function getValue(glEnum, values, cache) {
  return values[glEnum] !== undefined ? values[glEnum] : cache[glEnum];
}

var GL_COMPOSITE_PARAMETER_SETTERS = {
  blendEquation: function blendEquation(gl, values, cache) {
    return gl.blendEquationSeparate(getValue(32777, values, cache), getValue(34877, values, cache));
  },
  blendFunc: function blendFunc(gl, values, cache) {
    return gl.blendFuncSeparate(getValue(32969, values, cache), getValue(32968, values, cache), getValue(32971, values, cache), getValue(32970, values, cache));
  },
  polygonOffset: function polygonOffset(gl, values, cache) {
    return gl.polygonOffset(getValue(32824, values, cache), getValue(10752, values, cache));
  },
  sampleCoverage: function sampleCoverage(gl, values, cache) {
    return gl.sampleCoverage(getValue(32938, values, cache), getValue(32939, values, cache));
  },
  stencilFuncFront: function stencilFuncFront(gl, values, cache) {
    return gl.stencilFuncSeparate(1028, getValue(2962, values, cache), getValue(2967, values, cache), getValue(2963, values, cache));
  },
  stencilFuncBack: function stencilFuncBack(gl, values, cache) {
    return gl.stencilFuncSeparate(1029, getValue(34816, values, cache), getValue(36003, values, cache), getValue(36004, values, cache));
  },
  stencilOpFront: function stencilOpFront(gl, values, cache) {
    return gl.stencilOpSeparate(1028, getValue(2964, values, cache), getValue(2965, values, cache), getValue(2966, values, cache));
  },
  stencilOpBack: function stencilOpBack(gl, values, cache) {
    return gl.stencilOpSeparate(1029, getValue(34817, values, cache), getValue(34818, values, cache), getValue(34819, values, cache));
  }
};
exports.GL_COMPOSITE_PARAMETER_SETTERS = GL_COMPOSITE_PARAMETER_SETTERS;
var GL_HOOKED_SETTERS = {
  enable: function enable(update, capability) {
    return update((0, _defineProperty2["default"])({}, capability, true));
  },
  disable: function disable(update, capability) {
    return update((0, _defineProperty2["default"])({}, capability, false));
  },
  pixelStorei: function pixelStorei(update, pname, value) {
    return update((0, _defineProperty2["default"])({}, pname, value));
  },
  hint: function hint(update, pname, _hint) {
    return update((0, _defineProperty2["default"])({}, pname, _hint));
  },
  bindFramebuffer: function bindFramebuffer(update, target, framebuffer) {
    var _update5;

    switch (target) {
      case 36160:
        return update((_update5 = {}, (0, _defineProperty2["default"])(_update5, 36006, framebuffer), (0, _defineProperty2["default"])(_update5, 36010, framebuffer), _update5));

      case 36009:
        return update((0, _defineProperty2["default"])({}, 36006, framebuffer));

      case 36008:
        return update((0, _defineProperty2["default"])({}, 36010, framebuffer));

      default:
        return null;
    }
  },
  blendColor: function blendColor(update, r, g, b, a) {
    return update((0, _defineProperty2["default"])({}, 32773, new Float32Array([r, g, b, a])));
  },
  blendEquation: function blendEquation(update, mode) {
    var _update9;

    return update((_update9 = {}, (0, _defineProperty2["default"])(_update9, 32777, mode), (0, _defineProperty2["default"])(_update9, 34877, mode), _update9));
  },
  blendEquationSeparate: function blendEquationSeparate(update, modeRGB, modeAlpha) {
    var _update10;

    return update((_update10 = {}, (0, _defineProperty2["default"])(_update10, 32777, modeRGB), (0, _defineProperty2["default"])(_update10, 34877, modeAlpha), _update10));
  },
  blendFunc: function blendFunc(update, src, dst) {
    var _update11;

    return update((_update11 = {}, (0, _defineProperty2["default"])(_update11, 32969, src), (0, _defineProperty2["default"])(_update11, 32968, dst), (0, _defineProperty2["default"])(_update11, 32971, src), (0, _defineProperty2["default"])(_update11, 32970, dst), _update11));
  },
  blendFuncSeparate: function blendFuncSeparate(update, srcRGB, dstRGB, srcAlpha, dstAlpha) {
    var _update12;

    return update((_update12 = {}, (0, _defineProperty2["default"])(_update12, 32969, srcRGB), (0, _defineProperty2["default"])(_update12, 32968, dstRGB), (0, _defineProperty2["default"])(_update12, 32971, srcAlpha), (0, _defineProperty2["default"])(_update12, 32970, dstAlpha), _update12));
  },
  clearColor: function clearColor(update, r, g, b, a) {
    return update((0, _defineProperty2["default"])({}, 3106, new Float32Array([r, g, b, a])));
  },
  clearDepth: function clearDepth(update, depth) {
    return update((0, _defineProperty2["default"])({}, 2931, depth));
  },
  clearStencil: function clearStencil(update, s) {
    return update((0, _defineProperty2["default"])({}, 2961, s));
  },
  colorMask: function colorMask(update, r, g, b, a) {
    return update((0, _defineProperty2["default"])({}, 3107, [r, g, b, a]));
  },
  cullFace: function cullFace(update, mode) {
    return update((0, _defineProperty2["default"])({}, 2885, mode));
  },
  depthFunc: function depthFunc(update, func) {
    return update((0, _defineProperty2["default"])({}, 2932, func));
  },
  depthRange: function depthRange(update, zNear, zFar) {
    return update((0, _defineProperty2["default"])({}, 2928, new Float32Array([zNear, zFar])));
  },
  depthMask: function depthMask(update, mask) {
    return update((0, _defineProperty2["default"])({}, 2930, mask));
  },
  frontFace: function frontFace(update, face) {
    return update((0, _defineProperty2["default"])({}, 2886, face));
  },
  lineWidth: function lineWidth(update, width) {
    return update((0, _defineProperty2["default"])({}, 2849, width));
  },
  polygonOffset: function polygonOffset(update, factor, units) {
    var _update23;

    return update((_update23 = {}, (0, _defineProperty2["default"])(_update23, 32824, factor), (0, _defineProperty2["default"])(_update23, 10752, units), _update23));
  },
  sampleCoverage: function sampleCoverage(update, value, invert) {
    var _update24;

    return update((_update24 = {}, (0, _defineProperty2["default"])(_update24, 32938, value), (0, _defineProperty2["default"])(_update24, 32939, invert), _update24));
  },
  scissor: function scissor(update, x, y, width, height) {
    return update((0, _defineProperty2["default"])({}, 3088, new Int32Array([x, y, width, height])));
  },
  stencilMask: function stencilMask(update, mask) {
    var _update26;

    return update((_update26 = {}, (0, _defineProperty2["default"])(_update26, 2968, mask), (0, _defineProperty2["default"])(_update26, 36005, mask), _update26));
  },
  stencilMaskSeparate: function stencilMaskSeparate(update, face, mask) {
    return update((0, _defineProperty2["default"])({}, face === 1028 ? 2968 : 36005, mask));
  },
  stencilFunc: function stencilFunc(update, func, ref, mask) {
    var _update28;

    return update((_update28 = {}, (0, _defineProperty2["default"])(_update28, 2962, func), (0, _defineProperty2["default"])(_update28, 2967, ref), (0, _defineProperty2["default"])(_update28, 2963, mask), (0, _defineProperty2["default"])(_update28, 34816, func), (0, _defineProperty2["default"])(_update28, 36003, ref), (0, _defineProperty2["default"])(_update28, 36004, mask), _update28));
  },
  stencilFuncSeparate: function stencilFuncSeparate(update, face, func, ref, mask) {
    var _update29;

    return update((_update29 = {}, (0, _defineProperty2["default"])(_update29, face === 1028 ? 2962 : 34816, func), (0, _defineProperty2["default"])(_update29, face === 1028 ? 2967 : 36003, ref), (0, _defineProperty2["default"])(_update29, face === 1028 ? 2963 : 36004, mask), _update29));
  },
  stencilOp: function stencilOp(update, fail, zfail, zpass) {
    var _update30;

    return update((_update30 = {}, (0, _defineProperty2["default"])(_update30, 2964, fail), (0, _defineProperty2["default"])(_update30, 2965, zfail), (0, _defineProperty2["default"])(_update30, 2966, zpass), (0, _defineProperty2["default"])(_update30, 34817, fail), (0, _defineProperty2["default"])(_update30, 34818, zfail), (0, _defineProperty2["default"])(_update30, 34819, zpass), _update30));
  },
  stencilOpSeparate: function stencilOpSeparate(update, face, fail, zfail, zpass) {
    var _update31;

    return update((_update31 = {}, (0, _defineProperty2["default"])(_update31, face === 1028 ? 2964 : 34817, fail), (0, _defineProperty2["default"])(_update31, face === 1028 ? 2965 : 34818, zfail), (0, _defineProperty2["default"])(_update31, face === 1028 ? 2966 : 34819, zpass), _update31));
  },
  viewport: function viewport(update, x, y, width, height) {
    return update((0, _defineProperty2["default"])({}, 2978, [x, y, width, height]));
  }
};
exports.GL_HOOKED_SETTERS = GL_HOOKED_SETTERS;

var isEnabled = function isEnabled(gl, key) {
  return gl.isEnabled(key);
};

var GL_PARAMETER_GETTERS = (_GL_PARAMETER_GETTERS = {}, (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 3042, isEnabled), (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 2884, isEnabled), (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 2929, isEnabled), (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 3024, isEnabled), (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 32823, isEnabled), (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 32926, isEnabled), (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 32928, isEnabled), (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 3089, isEnabled), (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 2960, isEnabled), (0, _defineProperty2["default"])(_GL_PARAMETER_GETTERS, 35977, isEnabled), _GL_PARAMETER_GETTERS);
exports.GL_PARAMETER_GETTERS = GL_PARAMETER_GETTERS;
//# sourceMappingURL=webgl-parameter-tables.js.map