import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

var _GL_PARAMETER_DEFAULT, _GL_PARAMETER_SETTERS, _GL_PARAMETER_GETTERS;

import { isWebGL2 } from '../utils';
export var GL_PARAMETER_DEFAULTS = (_GL_PARAMETER_DEFAULT = {}, _defineProperty(_GL_PARAMETER_DEFAULT, 3042, false), _defineProperty(_GL_PARAMETER_DEFAULT, 32773, new Float32Array([0, 0, 0, 0])), _defineProperty(_GL_PARAMETER_DEFAULT, 32777, 32774), _defineProperty(_GL_PARAMETER_DEFAULT, 34877, 32774), _defineProperty(_GL_PARAMETER_DEFAULT, 32969, 1), _defineProperty(_GL_PARAMETER_DEFAULT, 32968, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 32971, 1), _defineProperty(_GL_PARAMETER_DEFAULT, 32970, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 3106, new Float32Array([0, 0, 0, 0])), _defineProperty(_GL_PARAMETER_DEFAULT, 3107, [true, true, true, true]), _defineProperty(_GL_PARAMETER_DEFAULT, 2884, false), _defineProperty(_GL_PARAMETER_DEFAULT, 2885, 1029), _defineProperty(_GL_PARAMETER_DEFAULT, 2929, false), _defineProperty(_GL_PARAMETER_DEFAULT, 2931, 1), _defineProperty(_GL_PARAMETER_DEFAULT, 2932, 513), _defineProperty(_GL_PARAMETER_DEFAULT, 2928, new Float32Array([0, 1])), _defineProperty(_GL_PARAMETER_DEFAULT, 2930, true), _defineProperty(_GL_PARAMETER_DEFAULT, 3024, true), _defineProperty(_GL_PARAMETER_DEFAULT, 36006, null), _defineProperty(_GL_PARAMETER_DEFAULT, 2886, 2305), _defineProperty(_GL_PARAMETER_DEFAULT, 33170, 4352), _defineProperty(_GL_PARAMETER_DEFAULT, 2849, 1), _defineProperty(_GL_PARAMETER_DEFAULT, 32823, false), _defineProperty(_GL_PARAMETER_DEFAULT, 32824, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 10752, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 32938, 1.0), _defineProperty(_GL_PARAMETER_DEFAULT, 32939, false), _defineProperty(_GL_PARAMETER_DEFAULT, 3089, false), _defineProperty(_GL_PARAMETER_DEFAULT, 3088, new Int32Array([0, 0, 1024, 1024])), _defineProperty(_GL_PARAMETER_DEFAULT, 2960, false), _defineProperty(_GL_PARAMETER_DEFAULT, 2961, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 2968, 0xffffffff), _defineProperty(_GL_PARAMETER_DEFAULT, 36005, 0xffffffff), _defineProperty(_GL_PARAMETER_DEFAULT, 2962, 519), _defineProperty(_GL_PARAMETER_DEFAULT, 2967, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 2963, 0xffffffff), _defineProperty(_GL_PARAMETER_DEFAULT, 34816, 519), _defineProperty(_GL_PARAMETER_DEFAULT, 36003, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 36004, 0xffffffff), _defineProperty(_GL_PARAMETER_DEFAULT, 2964, 7680), _defineProperty(_GL_PARAMETER_DEFAULT, 2965, 7680), _defineProperty(_GL_PARAMETER_DEFAULT, 2966, 7680), _defineProperty(_GL_PARAMETER_DEFAULT, 34817, 7680), _defineProperty(_GL_PARAMETER_DEFAULT, 34818, 7680), _defineProperty(_GL_PARAMETER_DEFAULT, 34819, 7680), _defineProperty(_GL_PARAMETER_DEFAULT, 2978, [0, 0, 1024, 1024]), _defineProperty(_GL_PARAMETER_DEFAULT, 3333, 4), _defineProperty(_GL_PARAMETER_DEFAULT, 3317, 4), _defineProperty(_GL_PARAMETER_DEFAULT, 37440, false), _defineProperty(_GL_PARAMETER_DEFAULT, 37441, false), _defineProperty(_GL_PARAMETER_DEFAULT, 37443, 37444), _defineProperty(_GL_PARAMETER_DEFAULT, 35723, 4352), _defineProperty(_GL_PARAMETER_DEFAULT, 36010, null), _defineProperty(_GL_PARAMETER_DEFAULT, 35977, false), _defineProperty(_GL_PARAMETER_DEFAULT, 3330, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 3332, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 3331, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 3314, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 32878, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 3316, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 3315, 0), _defineProperty(_GL_PARAMETER_DEFAULT, 32877, 0), _GL_PARAMETER_DEFAULT);

var enable = function enable(gl, value, key) {
  return value ? gl.enable(key) : gl.disable(key);
};

var hint = function hint(gl, value, key) {
  return gl.hint(key, value);
};

var pixelStorei = function pixelStorei(gl, value, key) {
  return gl.pixelStorei(key, value);
};

var drawFramebuffer = function drawFramebuffer(gl, value) {
  var target = isWebGL2(gl) ? 36009 : 36160;
  return gl.bindFramebuffer(target, value);
};

var readFramebuffer = function readFramebuffer(gl, value) {
  return gl.bindFramebuffer(36008, value);
};

function isArray(array) {
  return Array.isArray(array) || ArrayBuffer.isView(array);
}

export var GL_PARAMETER_SETTERS = (_GL_PARAMETER_SETTERS = {}, _defineProperty(_GL_PARAMETER_SETTERS, 3042, enable), _defineProperty(_GL_PARAMETER_SETTERS, 32773, function (gl, value) {
  return gl.blendColor.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, 32777, 'blendEquation'), _defineProperty(_GL_PARAMETER_SETTERS, 34877, 'blendEquation'), _defineProperty(_GL_PARAMETER_SETTERS, 32969, 'blendFunc'), _defineProperty(_GL_PARAMETER_SETTERS, 32968, 'blendFunc'), _defineProperty(_GL_PARAMETER_SETTERS, 32971, 'blendFunc'), _defineProperty(_GL_PARAMETER_SETTERS, 32970, 'blendFunc'), _defineProperty(_GL_PARAMETER_SETTERS, 3106, function (gl, value) {
  return gl.clearColor.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, 3107, function (gl, value) {
  return gl.colorMask.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, 2884, enable), _defineProperty(_GL_PARAMETER_SETTERS, 2885, function (gl, value) {
  return gl.cullFace(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, 2929, enable), _defineProperty(_GL_PARAMETER_SETTERS, 2931, function (gl, value) {
  return gl.clearDepth(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, 2932, function (gl, value) {
  return gl.depthFunc(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, 2928, function (gl, value) {
  return gl.depthRange.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, 2930, function (gl, value) {
  return gl.depthMask(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, 3024, enable), _defineProperty(_GL_PARAMETER_SETTERS, 35723, hint), _defineProperty(_GL_PARAMETER_SETTERS, 36006, drawFramebuffer), _defineProperty(_GL_PARAMETER_SETTERS, 2886, function (gl, value) {
  return gl.frontFace(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, 33170, hint), _defineProperty(_GL_PARAMETER_SETTERS, 2849, function (gl, value) {
  return gl.lineWidth(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, 32823, enable), _defineProperty(_GL_PARAMETER_SETTERS, 32824, 'polygonOffset'), _defineProperty(_GL_PARAMETER_SETTERS, 10752, 'polygonOffset'), _defineProperty(_GL_PARAMETER_SETTERS, 35977, enable), _defineProperty(_GL_PARAMETER_SETTERS, 32938, 'sampleCoverage'), _defineProperty(_GL_PARAMETER_SETTERS, 32939, 'sampleCoverage'), _defineProperty(_GL_PARAMETER_SETTERS, 3089, enable), _defineProperty(_GL_PARAMETER_SETTERS, 3088, function (gl, value) {
  return gl.scissor.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, 2960, enable), _defineProperty(_GL_PARAMETER_SETTERS, 2961, function (gl, value) {
  return gl.clearStencil(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, 2968, function (gl, value) {
  return gl.stencilMaskSeparate(1028, value);
}), _defineProperty(_GL_PARAMETER_SETTERS, 36005, function (gl, value) {
  return gl.stencilMaskSeparate(1029, value);
}), _defineProperty(_GL_PARAMETER_SETTERS, 2962, 'stencilFuncFront'), _defineProperty(_GL_PARAMETER_SETTERS, 2967, 'stencilFuncFront'), _defineProperty(_GL_PARAMETER_SETTERS, 2963, 'stencilFuncFront'), _defineProperty(_GL_PARAMETER_SETTERS, 34816, 'stencilFuncBack'), _defineProperty(_GL_PARAMETER_SETTERS, 36003, 'stencilFuncBack'), _defineProperty(_GL_PARAMETER_SETTERS, 36004, 'stencilFuncBack'), _defineProperty(_GL_PARAMETER_SETTERS, 2964, 'stencilOpFront'), _defineProperty(_GL_PARAMETER_SETTERS, 2965, 'stencilOpFront'), _defineProperty(_GL_PARAMETER_SETTERS, 2966, 'stencilOpFront'), _defineProperty(_GL_PARAMETER_SETTERS, 34817, 'stencilOpBack'), _defineProperty(_GL_PARAMETER_SETTERS, 34818, 'stencilOpBack'), _defineProperty(_GL_PARAMETER_SETTERS, 34819, 'stencilOpBack'), _defineProperty(_GL_PARAMETER_SETTERS, 2978, function (gl, value) {
  return gl.viewport.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, 3333, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 3317, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 37440, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 37441, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 37443, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 3330, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 3332, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 3331, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 36010, readFramebuffer), _defineProperty(_GL_PARAMETER_SETTERS, 3314, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 32878, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 3316, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 3315, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, 32877, pixelStorei), _defineProperty(_GL_PARAMETER_SETTERS, "framebuffer", function framebuffer(gl, _framebuffer) {
  var handle = _framebuffer && 'handle' in _framebuffer ? _framebuffer.handle : _framebuffer;
  return gl.bindFramebuffer(36160, handle);
}), _defineProperty(_GL_PARAMETER_SETTERS, "blend", function blend(gl, value) {
  return value ? gl.enable(3042) : gl.disable(3042);
}), _defineProperty(_GL_PARAMETER_SETTERS, "blendColor", function blendColor(gl, value) {
  return gl.blendColor.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, "blendEquation", function blendEquation(gl, args) {
  args = isArray(args) ? args : [args, args];
  gl.blendEquationSeparate.apply(gl, _toConsumableArray(args));
}), _defineProperty(_GL_PARAMETER_SETTERS, "blendFunc", function blendFunc(gl, args) {
  args = isArray(args) && args.length === 2 ? [].concat(_toConsumableArray(args), _toConsumableArray(args)) : args;
  gl.blendFuncSeparate.apply(gl, _toConsumableArray(args));
}), _defineProperty(_GL_PARAMETER_SETTERS, "clearColor", function clearColor(gl, value) {
  return gl.clearColor.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, "clearDepth", function clearDepth(gl, value) {
  return gl.clearDepth(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, "clearStencil", function clearStencil(gl, value) {
  return gl.clearStencil(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, "colorMask", function colorMask(gl, value) {
  return gl.colorMask.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, "cull", function cull(gl, value) {
  return value ? gl.enable(2884) : gl.disable(2884);
}), _defineProperty(_GL_PARAMETER_SETTERS, "cullFace", function cullFace(gl, value) {
  return gl.cullFace(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, "depthTest", function depthTest(gl, value) {
  return value ? gl.enable(2929) : gl.disable(2929);
}), _defineProperty(_GL_PARAMETER_SETTERS, "depthFunc", function depthFunc(gl, value) {
  return gl.depthFunc(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, "depthMask", function depthMask(gl, value) {
  return gl.depthMask(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, "depthRange", function depthRange(gl, value) {
  return gl.depthRange.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, "dither", function dither(gl, value) {
  return value ? gl.enable(3024) : gl.disable(3024);
}), _defineProperty(_GL_PARAMETER_SETTERS, "derivativeHint", function derivativeHint(gl, value) {
  gl.hint(35723, value);
}), _defineProperty(_GL_PARAMETER_SETTERS, "frontFace", function frontFace(gl, value) {
  return gl.frontFace(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, "mipmapHint", function mipmapHint(gl, value) {
  return gl.hint(33170, value);
}), _defineProperty(_GL_PARAMETER_SETTERS, "lineWidth", function lineWidth(gl, value) {
  return gl.lineWidth(value);
}), _defineProperty(_GL_PARAMETER_SETTERS, "polygonOffsetFill", function polygonOffsetFill(gl, value) {
  return value ? gl.enable(32823) : gl.disable(32823);
}), _defineProperty(_GL_PARAMETER_SETTERS, "polygonOffset", function polygonOffset(gl, value) {
  return gl.polygonOffset.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, "sampleCoverage", function sampleCoverage(gl, value) {
  return gl.sampleCoverage.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, "scissorTest", function scissorTest(gl, value) {
  return value ? gl.enable(3089) : gl.disable(3089);
}), _defineProperty(_GL_PARAMETER_SETTERS, "scissor", function scissor(gl, value) {
  return gl.scissor.apply(gl, _toConsumableArray(value));
}), _defineProperty(_GL_PARAMETER_SETTERS, "stencilTest", function stencilTest(gl, value) {
  return value ? gl.enable(2960) : gl.disable(2960);
}), _defineProperty(_GL_PARAMETER_SETTERS, "stencilMask", function stencilMask(gl, value) {
  value = isArray(value) ? value : [value, value];

  var _value = value,
      _value2 = _slicedToArray(_value, 2),
      mask = _value2[0],
      backMask = _value2[1];

  gl.stencilMaskSeparate(1028, mask);
  gl.stencilMaskSeparate(1029, backMask);
}), _defineProperty(_GL_PARAMETER_SETTERS, "stencilFunc", function stencilFunc(gl, args) {
  args = isArray(args) && args.length === 3 ? [].concat(_toConsumableArray(args), _toConsumableArray(args)) : args;

  var _args = args,
      _args2 = _slicedToArray(_args, 6),
      func = _args2[0],
      ref = _args2[1],
      mask = _args2[2],
      backFunc = _args2[3],
      backRef = _args2[4],
      backMask = _args2[5];

  gl.stencilFuncSeparate(1028, func, ref, mask);
  gl.stencilFuncSeparate(1029, backFunc, backRef, backMask);
}), _defineProperty(_GL_PARAMETER_SETTERS, "stencilOp", function stencilOp(gl, args) {
  args = isArray(args) && args.length === 3 ? [].concat(_toConsumableArray(args), _toConsumableArray(args)) : args;

  var _args3 = args,
      _args4 = _slicedToArray(_args3, 6),
      sfail = _args4[0],
      dpfail = _args4[1],
      dppass = _args4[2],
      backSfail = _args4[3],
      backDpfail = _args4[4],
      backDppass = _args4[5];

  gl.stencilOpSeparate(1028, sfail, dpfail, dppass);
  gl.stencilOpSeparate(1029, backSfail, backDpfail, backDppass);
}), _defineProperty(_GL_PARAMETER_SETTERS, "viewport", function viewport(gl, value) {
  return gl.viewport.apply(gl, _toConsumableArray(value));
}), _GL_PARAMETER_SETTERS);

function getValue(glEnum, values, cache) {
  return values[glEnum] !== undefined ? values[glEnum] : cache[glEnum];
}

export var GL_COMPOSITE_PARAMETER_SETTERS = {
  blendEquation: function blendEquation(gl, values, cache) {
    return gl.blendEquationSeparate(getValue(32777, values, cache), getValue(34877, values, cache));
  },
  blendFunc: function blendFunc(gl, values, cache) {
    return gl.blendFuncSeparate(getValue(32969, values, cache), getValue(32968, values, cache), getValue(32971, values, cache), getValue(32970, values, cache));
  },
  polygonOffset: function polygonOffset(gl, values, cache) {
    return gl.polygonOffset(getValue(32824, values, cache), getValue(10752, values, cache));
  },
  sampleCoverage: function sampleCoverage(gl, values, cache) {
    return gl.sampleCoverage(getValue(32938, values, cache), getValue(32939, values, cache));
  },
  stencilFuncFront: function stencilFuncFront(gl, values, cache) {
    return gl.stencilFuncSeparate(1028, getValue(2962, values, cache), getValue(2967, values, cache), getValue(2963, values, cache));
  },
  stencilFuncBack: function stencilFuncBack(gl, values, cache) {
    return gl.stencilFuncSeparate(1029, getValue(34816, values, cache), getValue(36003, values, cache), getValue(36004, values, cache));
  },
  stencilOpFront: function stencilOpFront(gl, values, cache) {
    return gl.stencilOpSeparate(1028, getValue(2964, values, cache), getValue(2965, values, cache), getValue(2966, values, cache));
  },
  stencilOpBack: function stencilOpBack(gl, values, cache) {
    return gl.stencilOpSeparate(1029, getValue(34817, values, cache), getValue(34818, values, cache), getValue(34819, values, cache));
  }
};
export var GL_HOOKED_SETTERS = {
  enable: function enable(update, capability) {
    return update(_defineProperty({}, capability, true));
  },
  disable: function disable(update, capability) {
    return update(_defineProperty({}, capability, false));
  },
  pixelStorei: function pixelStorei(update, pname, value) {
    return update(_defineProperty({}, pname, value));
  },
  hint: function hint(update, pname, _hint) {
    return update(_defineProperty({}, pname, _hint));
  },
  bindFramebuffer: function bindFramebuffer(update, target, framebuffer) {
    var _update5;

    switch (target) {
      case 36160:
        return update((_update5 = {}, _defineProperty(_update5, 36006, framebuffer), _defineProperty(_update5, 36010, framebuffer), _update5));

      case 36009:
        return update(_defineProperty({}, 36006, framebuffer));

      case 36008:
        return update(_defineProperty({}, 36010, framebuffer));

      default:
        return null;
    }
  },
  blendColor: function blendColor(update, r, g, b, a) {
    return update(_defineProperty({}, 32773, new Float32Array([r, g, b, a])));
  },
  blendEquation: function blendEquation(update, mode) {
    var _update9;

    return update((_update9 = {}, _defineProperty(_update9, 32777, mode), _defineProperty(_update9, 34877, mode), _update9));
  },
  blendEquationSeparate: function blendEquationSeparate(update, modeRGB, modeAlpha) {
    var _update10;

    return update((_update10 = {}, _defineProperty(_update10, 32777, modeRGB), _defineProperty(_update10, 34877, modeAlpha), _update10));
  },
  blendFunc: function blendFunc(update, src, dst) {
    var _update11;

    return update((_update11 = {}, _defineProperty(_update11, 32969, src), _defineProperty(_update11, 32968, dst), _defineProperty(_update11, 32971, src), _defineProperty(_update11, 32970, dst), _update11));
  },
  blendFuncSeparate: function blendFuncSeparate(update, srcRGB, dstRGB, srcAlpha, dstAlpha) {
    var _update12;

    return update((_update12 = {}, _defineProperty(_update12, 32969, srcRGB), _defineProperty(_update12, 32968, dstRGB), _defineProperty(_update12, 32971, srcAlpha), _defineProperty(_update12, 32970, dstAlpha), _update12));
  },
  clearColor: function clearColor(update, r, g, b, a) {
    return update(_defineProperty({}, 3106, new Float32Array([r, g, b, a])));
  },
  clearDepth: function clearDepth(update, depth) {
    return update(_defineProperty({}, 2931, depth));
  },
  clearStencil: function clearStencil(update, s) {
    return update(_defineProperty({}, 2961, s));
  },
  colorMask: function colorMask(update, r, g, b, a) {
    return update(_defineProperty({}, 3107, [r, g, b, a]));
  },
  cullFace: function cullFace(update, mode) {
    return update(_defineProperty({}, 2885, mode));
  },
  depthFunc: function depthFunc(update, func) {
    return update(_defineProperty({}, 2932, func));
  },
  depthRange: function depthRange(update, zNear, zFar) {
    return update(_defineProperty({}, 2928, new Float32Array([zNear, zFar])));
  },
  depthMask: function depthMask(update, mask) {
    return update(_defineProperty({}, 2930, mask));
  },
  frontFace: function frontFace(update, face) {
    return update(_defineProperty({}, 2886, face));
  },
  lineWidth: function lineWidth(update, width) {
    return update(_defineProperty({}, 2849, width));
  },
  polygonOffset: function polygonOffset(update, factor, units) {
    var _update23;

    return update((_update23 = {}, _defineProperty(_update23, 32824, factor), _defineProperty(_update23, 10752, units), _update23));
  },
  sampleCoverage: function sampleCoverage(update, value, invert) {
    var _update24;

    return update((_update24 = {}, _defineProperty(_update24, 32938, value), _defineProperty(_update24, 32939, invert), _update24));
  },
  scissor: function scissor(update, x, y, width, height) {
    return update(_defineProperty({}, 3088, new Int32Array([x, y, width, height])));
  },
  stencilMask: function stencilMask(update, mask) {
    var _update26;

    return update((_update26 = {}, _defineProperty(_update26, 2968, mask), _defineProperty(_update26, 36005, mask), _update26));
  },
  stencilMaskSeparate: function stencilMaskSeparate(update, face, mask) {
    return update(_defineProperty({}, face === 1028 ? 2968 : 36005, mask));
  },
  stencilFunc: function stencilFunc(update, func, ref, mask) {
    var _update28;

    return update((_update28 = {}, _defineProperty(_update28, 2962, func), _defineProperty(_update28, 2967, ref), _defineProperty(_update28, 2963, mask), _defineProperty(_update28, 34816, func), _defineProperty(_update28, 36003, ref), _defineProperty(_update28, 36004, mask), _update28));
  },
  stencilFuncSeparate: function stencilFuncSeparate(update, face, func, ref, mask) {
    var _update29;

    return update((_update29 = {}, _defineProperty(_update29, face === 1028 ? 2962 : 34816, func), _defineProperty(_update29, face === 1028 ? 2967 : 36003, ref), _defineProperty(_update29, face === 1028 ? 2963 : 36004, mask), _update29));
  },
  stencilOp: function stencilOp(update, fail, zfail, zpass) {
    var _update30;

    return update((_update30 = {}, _defineProperty(_update30, 2964, fail), _defineProperty(_update30, 2965, zfail), _defineProperty(_update30, 2966, zpass), _defineProperty(_update30, 34817, fail), _defineProperty(_update30, 34818, zfail), _defineProperty(_update30, 34819, zpass), _update30));
  },
  stencilOpSeparate: function stencilOpSeparate(update, face, fail, zfail, zpass) {
    var _update31;

    return update((_update31 = {}, _defineProperty(_update31, face === 1028 ? 2964 : 34817, fail), _defineProperty(_update31, face === 1028 ? 2965 : 34818, zfail), _defineProperty(_update31, face === 1028 ? 2966 : 34819, zpass), _update31));
  },
  viewport: function viewport(update, x, y, width, height) {
    return update(_defineProperty({}, 2978, [x, y, width, height]));
  }
};

var isEnabled = function isEnabled(gl, key) {
  return gl.isEnabled(key);
};

export var GL_PARAMETER_GETTERS = (_GL_PARAMETER_GETTERS = {}, _defineProperty(_GL_PARAMETER_GETTERS, 3042, isEnabled), _defineProperty(_GL_PARAMETER_GETTERS, 2884, isEnabled), _defineProperty(_GL_PARAMETER_GETTERS, 2929, isEnabled), _defineProperty(_GL_PARAMETER_GETTERS, 3024, isEnabled), _defineProperty(_GL_PARAMETER_GETTERS, 32823, isEnabled), _defineProperty(_GL_PARAMETER_GETTERS, 32926, isEnabled), _defineProperty(_GL_PARAMETER_GETTERS, 32928, isEnabled), _defineProperty(_GL_PARAMETER_GETTERS, 3089, isEnabled), _defineProperty(_GL_PARAMETER_GETTERS, 2960, isEnabled), _defineProperty(_GL_PARAMETER_GETTERS, 35977, isEnabled), _GL_PARAMETER_GETTERS);
//# sourceMappingURL=webgl-parameter-tables.js.map