"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "fp64ify", {
  enumerable: true,
  get: function get() {
    return _fp64Utils.fp64ify;
  }
});
Object.defineProperty(exports, "fp64LowPart", {
  enumerable: true,
  get: function get() {
    return _fp64Utils.fp64LowPart;
  }
});
Object.defineProperty(exports, "fp64ifyMatrix4", {
  enumerable: true,
  get: function get() {
    return _fp64Utils.fp64ifyMatrix4;
  }
});
exports["default"] = exports.fp64arithmetic = void 0;

var _fp64Utils = require("./fp64-utils");

var _fp64Arithmetic = _interopRequireDefault(require("./fp64-arithmetic.glsl"));

var _fp64Functions = _interopRequireDefault(require("./fp64-functions.glsl"));

var CONST_UNIFORMS = {
  ONE: 1.0
};

function getUniforms() {
  return CONST_UNIFORMS;
}

var fp64arithmetic = {
  name: 'fp64-arithmetic',
  vs: _fp64Arithmetic["default"],
  fs: null,
  getUniforms: getUniforms,
  fp64ify: _fp64Utils.fp64ify,
  fp64LowPart: _fp64Utils.fp64LowPart
};
exports.fp64arithmetic = fp64arithmetic;
var _default = {
  name: 'fp64',
  vs: _fp64Functions["default"],
  fs: null,
  dependencies: [fp64arithmetic],
  fp64ify: _fp64Utils.fp64ify,
  fp64LowPart: _fp64Utils.fp64LowPart,
  fp64ifyMatrix4: _fp64Utils.fp64ifyMatrix4
};
exports["default"] = _default;
//# sourceMappingURL=fp64.js.map