import { assert } from '../utils';
const FS100 = "void main() {gl_FragColor = vec4(0);}";
const FS_GLES = "out vec4 transform_output;\nvoid main() {\n  transform_output = vec4(0);\n}";
const FS300 = "#version 300 es\n".concat(FS_GLES);
export function getQualifierDetails(line, qualifiers) {
  qualifiers = Array.isArray(qualifiers) ? qualifiers : [qualifiers];
  const words = line.replace(/^\s+/, '').split(/\s+/);
  const [qualifier, type, definition] = words;

  if (!qualifiers.includes(qualifier) || !type || !definition) {
    return null;
  }

  const name = definition.split(';')[0];
  return {
    qualifier,
    type,
    name
  };
}
export function getPassthroughFS({
  version = 100,
  input,
  inputType,
  output
} = {}) {
  if (!input) {
    if (version === 300) {
      return FS300;
    } else if (version > 300) {
      return "#version ".concat(version, "\n").concat(FS_GLES);
    }

    return FS100;
  }

  const outputValue = convertToVec4(input, inputType);

  if (version >= 300) {
    return "#version ".concat(version, " ").concat(version === 300 ? 'es' : '', "\nin ").concat(inputType, " ").concat(input, ";\nout vec4 ").concat(output, ";\nvoid main() {\n  ").concat(output, " = ").concat(outputValue, ";\n}");
  }

  return "varying ".concat(inputType, " ").concat(input, ";\nvoid main() {\n  gl_FragColor = ").concat(outputValue, ";\n}");
}
export function typeToChannelSuffix(type) {
  switch (type) {
    case 'float':
      return 'x';

    case 'vec2':
      return 'xy';

    case 'vec3':
      return 'xyz';

    case 'vec4':
      return 'xyzw';

    default:
      assert(false);
      return null;
  }
}
export function typeToChannelCount(type) {
  switch (type) {
    case 'float':
      return 1;

    case 'vec2':
      return 2;

    case 'vec3':
      return 3;

    case 'vec4':
      return 4;

    default:
      assert(false);
      return null;
  }
}
export function convertToVec4(variable, type) {
  switch (type) {
    case 'float':
      return "vec4(".concat(variable, ", 0.0, 0.0, 1.0)");

    case 'vec2':
      return "vec4(".concat(variable, ", 0.0, 1.0)");

    case 'vec3':
      return "vec4(".concat(variable, ", 1.0)");

    case 'vec4':
      return variable;

    default:
      assert(false);
      return null;
  }
}
//# sourceMappingURL=shader-utils.js.map