import _typeof from "@babel/runtime/helpers/esm/typeof";
var TYPE_DEFINITIONS = {
  number: {
    validate: function validate(value, propType) {
      return Number.isFinite(value) && (!('max' in propType) || value <= propType.max) && (!('min' in propType) || value >= propType.min);
    }
  },
  array: {
    validate: function validate(value, propType) {
      return Array.isArray(value) || ArrayBuffer.isView(value);
    }
  }
};
export function parsePropTypes(propDefs) {
  var propTypes = {};

  for (var propName in propDefs) {
    var propDef = propDefs[propName];
    var propType = parsePropType(propDef);
    propTypes[propName] = propType;
  }

  return propTypes;
}

function parsePropType(propDef) {
  var type = getTypeOf(propDef);

  if (type === 'object') {
    if (!propDef) {
      return {
        type: 'object',
        value: null
      };
    }

    if ('type' in propDef) {
      return Object.assign({}, propDef, TYPE_DEFINITIONS[propDef.type]);
    }

    if (!('value' in propDef)) {
      return {
        type: 'object',
        value: propDef
      };
    }

    type = getTypeOf(propDef.value);
    return Object.assign({
      type: type
    }, propDef, TYPE_DEFINITIONS[type]);
  }

  return Object.assign({
    type: type,
    value: propDef
  }, TYPE_DEFINITIONS[type]);
}

function getTypeOf(value) {
  if (Array.isArray(value) || ArrayBuffer.isView(value)) {
    return 'array';
  }

  return _typeof(value);
}
//# sourceMappingURL=prop-types.js.map