import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

var _MODULE_INJECTORS;

import { MODULE_INJECTORS_VS, MODULE_INJECTORS_FS } from '../modules/module-injectors';
import { VERTEX_SHADER, FRAGMENT_SHADER } from './constants';
import { assert } from '../utils';
var MODULE_INJECTORS = (_MODULE_INJECTORS = {}, _defineProperty(_MODULE_INJECTORS, VERTEX_SHADER, MODULE_INJECTORS_VS), _defineProperty(_MODULE_INJECTORS, FRAGMENT_SHADER, MODULE_INJECTORS_FS), _MODULE_INJECTORS);
export var DECLARATION_INJECT_MARKER = '__LUMA_INJECT_DECLARATIONS__';
var REGEX_START_OF_MAIN = /void\s+main\s*\([^)]*\)\s*\{\n?/;
var REGEX_END_OF_MAIN = /}\n?[^{}]*$/;
var fragments = [];
export default function injectShader(source, type, inject, injectStandardStubs) {
  var isVertex = type === VERTEX_SHADER;

  var _loop = function _loop(key) {
    var fragmentData = inject[key];
    fragmentData.sort(function (a, b) {
      return a.order - b.order;
    });
    fragments.length = fragmentData.length;

    for (var i = 0, len = fragmentData.length; i < len; ++i) {
      fragments[i] = fragmentData[i].injection;
    }

    var fragmentString = "".concat(fragments.join('\n'), "\n");

    switch (key) {
      case 'vs:#decl':
        if (isVertex) {
          source = source.replace(DECLARATION_INJECT_MARKER, fragmentString);
        }

        break;

      case 'vs:#main-start':
        if (isVertex) {
          source = source.replace(REGEX_START_OF_MAIN, function (match) {
            return match + fragmentString;
          });
        }

        break;

      case 'vs:#main-end':
        if (isVertex) {
          source = source.replace(REGEX_END_OF_MAIN, function (match) {
            return fragmentString + match;
          });
        }

        break;

      case 'fs:#decl':
        if (!isVertex) {
          source = source.replace(DECLARATION_INJECT_MARKER, fragmentString);
        }

        break;

      case 'fs:#main-start':
        if (!isVertex) {
          source = source.replace(REGEX_START_OF_MAIN, function (match) {
            return match + fragmentString;
          });
        }

        break;

      case 'fs:#main-end':
        if (!isVertex) {
          source = source.replace(REGEX_END_OF_MAIN, function (match) {
            return fragmentString + match;
          });
        }

        break;

      default:
        source = source.replace(key, function (match) {
          return match + fragmentString;
        });
    }
  };

  for (var key in inject) {
    _loop(key);
  }

  source = source.replace(DECLARATION_INJECT_MARKER, '');

  if (injectStandardStubs) {
    source = source.replace(/\}\s*$/, function (match) {
      return match + MODULE_INJECTORS[type];
    });
  }

  return source;
}
export function combineInjects(injects) {
  var result = {};
  assert(Array.isArray(injects) && injects.length > 1);
  injects.forEach(function (inject) {
    for (var key in inject) {
      result[key] = result[key] ? "".concat(result[key], "\n").concat(inject[key]) : inject[key];
    }
  });
  return result;
}
//# sourceMappingURL=inject-shader.js.map