import lights from '../lights/lights';
import lightingShader from './phong-lighting.glsl';
var gouraudLighting = {
  name: 'gouraud-lighting',
  dependencies: [lights],
  vs: lightingShader,
  defines: {
    LIGHTING_VERTEX: 1
  },
  getUniforms: getUniforms
};
var phongLighting = {
  name: 'phong-lighting',
  dependencies: [lights],
  fs: lightingShader,
  defines: {
    LIGHTING_FRAGMENT: 1
  },
  getUniforms: getUniforms
};
var INITIAL_MODULE_OPTIONS = {};

function getMaterialUniforms(material) {
  var _material$ambient = material.ambient,
      ambient = _material$ambient === void 0 ? 0.35 : _material$ambient,
      _material$diffuse = material.diffuse,
      diffuse = _material$diffuse === void 0 ? 0.6 : _material$diffuse,
      _material$shininess = material.shininess,
      shininess = _material$shininess === void 0 ? 32 : _material$shininess,
      _material$specularCol = material.specularColor,
      specularColor = _material$specularCol === void 0 ? [30, 30, 30] : _material$specularCol;
  return {
    lighting_uAmbient: ambient,
    lighting_uDiffuse: diffuse,
    lighting_uShininess: shininess,
    lighting_uSpecularColor: specularColor.map(function (x) {
      return x / 255;
    })
  };
}

function getUniforms() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : INITIAL_MODULE_OPTIONS;

  if (!('material' in opts)) {
    return {};
  }

  var material = opts.material;

  if (!material) {
    return {
      lighting_uEnabled: false
    };
  }

  return getMaterialUniforms(material);
}

export { gouraudLighting, phongLighting };
//# sourceMappingURL=phong-lighting.js.map