"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assembleShaders = assembleShaders;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _constants = require("./constants");

var _resolveModules = require("./resolve-modules");

var _platformDefines = require("./platform-defines");

var _injectShader = _interopRequireWildcard(require("./inject-shader"));

var _transpileShader = _interopRequireDefault(require("./transpile-shader"));

var _utils = require("../utils");

var _SHADER_TYPE;

var INJECT_SHADER_DECLARATIONS = "\n\n".concat(_injectShader.DECLARATION_INJECT_MARKER, "\n\n");
var SHADER_TYPE = (_SHADER_TYPE = {}, (0, _defineProperty2["default"])(_SHADER_TYPE, _constants.VERTEX_SHADER, 'vertex'), (0, _defineProperty2["default"])(_SHADER_TYPE, _constants.FRAGMENT_SHADER, 'fragment'), _SHADER_TYPE);
var FRAGMENT_SHADER_PROLOGUE = "precision highp float;\n\n";

function assembleShaders(gl, opts) {
  var vs = opts.vs,
      fs = opts.fs;
  var modules = (0, _resolveModules.resolveModules)(opts.modules || []);
  return {
    gl: gl,
    vs: assembleShader(gl, Object.assign({}, opts, {
      source: vs,
      type: _constants.VERTEX_SHADER,
      modules: modules
    })),
    fs: assembleShader(gl, Object.assign({}, opts, {
      source: fs,
      type: _constants.FRAGMENT_SHADER,
      modules: modules
    })),
    getUniforms: assembleGetUniforms(modules)
  };
}

function assembleShader(gl, _ref) {
  var id = _ref.id,
      source = _ref.source,
      type = _ref.type,
      modules = _ref.modules,
      _ref$defines = _ref.defines,
      defines = _ref$defines === void 0 ? {} : _ref$defines,
      _ref$hookFunctions = _ref.hookFunctions,
      hookFunctions = _ref$hookFunctions === void 0 ? [] : _ref$hookFunctions,
      _ref$inject = _ref.inject,
      inject = _ref$inject === void 0 ? {} : _ref$inject,
      _ref$transpileToGLSL = _ref.transpileToGLSL100,
      transpileToGLSL100 = _ref$transpileToGLSL === void 0 ? false : _ref$transpileToGLSL,
      _ref$prologue = _ref.prologue,
      prologue = _ref$prologue === void 0 ? true : _ref$prologue,
      log = _ref.log;
  (0, _utils.assert)(typeof source === 'string', 'shader source must be a string');
  var isVertex = type === _constants.VERTEX_SHADER;
  var sourceLines = source.split('\n');
  var glslVersion = 100;
  var versionLine = '';
  var coreSource = source;

  if (sourceLines[0].indexOf('#version ') === 0) {
    glslVersion = 300;
    versionLine = sourceLines[0];
    coreSource = sourceLines.slice(1).join('\n');
  } else {
    versionLine = "#version ".concat(glslVersion);
  }

  var allDefines = {};
  modules.forEach(function (module) {
    Object.assign(allDefines, module.getDefines());
  });
  Object.assign(allDefines, defines);
  var assembledSource = prologue ? "".concat(versionLine, "\n").concat(getShaderName({
    id: id,
    source: source,
    type: type
  }), "\n").concat(getShaderType({
    type: type
  }), "\n").concat((0, _platformDefines.getPlatformShaderDefines)(gl), "\n").concat((0, _platformDefines.getVersionDefines)(gl, glslVersion, !isVertex), "\n").concat(getApplicationDefines(allDefines), "\n").concat(isVertex ? '' : FRAGMENT_SHADER_PROLOGUE, "\n") : "".concat(versionLine, "\n");
  hookFunctions = normalizeHookFunctions(hookFunctions);
  var hookInjections = {};
  var declInjections = {};
  var mainInjections = {};

  for (var key in inject) {
    var injection = typeof inject[key] === 'string' ? {
      injection: inject[key],
      order: 0
    } : inject[key];
    var match = key.match(/^(v|f)s:(#)?([\w-]+)$/);

    if (match) {
      var hash = match[2];
      var name = match[3];

      if (hash) {
        if (name === 'decl') {
          declInjections[key] = [injection];
        } else {
          mainInjections[key] = [injection];
        }
      } else {
        hookInjections[key] = [injection];
      }
    } else {
      mainInjections[key] = [injection];
    }
  }

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = modules[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var module = _step.value;

      if (log) {
        module.checkDeprecations(coreSource, log);
      }

      var moduleSource = module.getModuleSource(type, glslVersion);
      assembledSource += moduleSource;
      var injections = module.injections[type];

      for (var _key in injections) {
        var _match = _key.match(/^(v|f)s:#([\w-]+)$/);

        if (_match) {
          var _name = _match[2];
          var injectionType = _name === 'decl' ? declInjections : mainInjections;
          injectionType[_key] = injectionType[_key] || [];

          injectionType[_key].push(injections[_key]);
        } else {
          hookInjections[_key] = hookInjections[_key] || [];

          hookInjections[_key].push(injections[_key]);
        }
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  assembledSource += INJECT_SHADER_DECLARATIONS;
  assembledSource = (0, _injectShader["default"])(assembledSource, type, declInjections);
  assembledSource += getHookFunctions(hookFunctions[type], hookInjections);
  assembledSource += coreSource;
  assembledSource = (0, _injectShader["default"])(assembledSource, type, mainInjections);
  assembledSource = (0, _transpileShader["default"])(assembledSource, transpileToGLSL100 ? 100 : glslVersion, isVertex);
  return assembledSource;
}

function assembleGetUniforms(modules) {
  return function getUniforms(opts) {
    var uniforms = {};
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
      for (var _iterator2 = modules[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
        var module = _step2.value;
        var moduleUniforms = module.getUniforms(opts, uniforms);
        Object.assign(uniforms, moduleUniforms);
      }
    } catch (err) {
      _didIteratorError2 = true;
      _iteratorError2 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
          _iterator2["return"]();
        }
      } finally {
        if (_didIteratorError2) {
          throw _iteratorError2;
        }
      }
    }

    return uniforms;
  };
}

function getShaderType(_ref2) {
  var type = _ref2.type;
  return "\n#define SHADER_TYPE_".concat(SHADER_TYPE[type].toUpperCase(), "\n");
}

function getShaderName(_ref3) {
  var id = _ref3.id,
      source = _ref3.source,
      type = _ref3.type;
  var injectShaderName = id && typeof id === 'string' && source.indexOf('SHADER_NAME') === -1;
  return injectShaderName ? "\n#define SHADER_NAME ".concat(id, "_").concat(SHADER_TYPE[type], "\n\n") : '';
}

function getApplicationDefines() {
  var defines = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var count = 0;
  var sourceText = '';

  for (var define in defines) {
    if (count === 0) {
      sourceText += '\n// APPLICATION DEFINES\n';
    }

    count++;
    var value = defines[define];

    if (value || Number.isFinite(value)) {
      sourceText += "#define ".concat(define.toUpperCase(), " ").concat(defines[define], "\n");
    }
  }

  if (count === 0) {
    sourceText += '\n';
  }

  return sourceText;
}

function getHookFunctions(hookFunctions, hookInjections) {
  var result = '';

  for (var hookName in hookFunctions) {
    var hookFunction = hookFunctions[hookName];
    result += "void ".concat(hookFunction.signature, " {\n");

    if (hookFunction.header) {
      result += "  ".concat(hookFunction.header);
    }

    if (hookInjections[hookName]) {
      var injections = hookInjections[hookName];
      injections.sort(function (a, b) {
        return a.order - b.order;
      });
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = injections[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var injection = _step3.value;
          result += "  ".concat(injection.injection, "\n");
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3["return"] != null) {
            _iterator3["return"]();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }

    if (hookFunction.footer) {
      result += "  ".concat(hookFunction.footer);
    }

    result += '}\n';
  }

  return result;
}

function normalizeHookFunctions(hookFunctions) {
  var result = {
    vs: {},
    fs: {}
  };
  hookFunctions.forEach(function (hook) {
    var opts;

    if (typeof hook !== 'string') {
      opts = hook;
      hook = opts.hook;
    } else {
      opts = {};
    }

    hook = hook.trim();

    var _hook$split = hook.split(':'),
        _hook$split2 = (0, _slicedToArray2["default"])(_hook$split, 2),
        stage = _hook$split2[0],
        signature = _hook$split2[1];

    var name = hook.replace(/\(.+/, '');
    result[stage][name] = Object.assign(opts, {
      signature: signature
    });
  });
  return result;
}
//# sourceMappingURL=assemble-shaders.js.map