"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = "#if (__VERSION__ < 300)\n#extension GL_EXT_shader_texture_lod: enable\n#extension GL_OES_standard_derivatives : enable\n#endif\n\n\n#if (__VERSION__ < 300)\n  #define SMART_FOR(INIT, WEBGL1COND, WEBGL2COND, INCR) for (INIT; WEBGL1COND; INCR)\n#else\n  #define SMART_FOR(INIT, WEBGL1COND, WEBGL2COND, INCR) for (INIT; WEBGL2COND; INCR)\n#endif\n\nprecision highp float;\n\n#ifdef USE_IBL\nuniform samplerCube u_DiffuseEnvSampler;\nuniform samplerCube u_SpecularEnvSampler;\nuniform sampler2D u_brdfLUT;\nuniform vec2 u_ScaleIBLAmbient;\n#endif\n\n#ifdef HAS_BASECOLORMAP\nuniform sampler2D u_BaseColorSampler;\n#endif\n#ifdef HAS_NORMALMAP\nuniform sampler2D u_NormalSampler;\nuniform float u_NormalScale;\n#endif\n#ifdef HAS_EMISSIVEMAP\nuniform sampler2D u_EmissiveSampler;\nuniform vec3 u_EmissiveFactor;\n#endif\n#ifdef HAS_METALROUGHNESSMAP\nuniform sampler2D u_MetallicRoughnessSampler;\n#endif\n#ifdef HAS_OCCLUSIONMAP\nuniform sampler2D u_OcclusionSampler;\nuniform float u_OcclusionStrength;\n#endif\n\n#ifdef ALPHA_CUTOFF\nuniform float u_AlphaCutoff;\n#endif\n\nuniform vec2 u_MetallicRoughnessValues;\nuniform vec4 u_BaseColorFactor;\n\nuniform vec3 u_Camera;\n#ifdef PBR_DEBUG\nuniform vec4 u_ScaleDiffBaseMR;\nuniform vec4 u_ScaleFGDSpec;\n#endif\n\nvarying vec3 pbr_vPosition;\n\nvarying vec2 pbr_vUV;\n\n#ifdef HAS_NORMALS\n#ifdef HAS_TANGENTS\nvarying mat3 pbr_vTBN;\n#else\nvarying vec3 pbr_vNormal;\n#endif\n#endif\n\n\nstruct PBRInfo\n{\n  float NdotL;\n  float NdotV;\n  float NdotH;\n  float LdotH;\n  float VdotH;\n  float perceptualRoughness;\n  float metalness;\n  vec3 reflectance0;\n  vec3 reflectance90;\n  float alphaRoughness;\n  vec3 diffuseColor;\n  vec3 specularColor;\n  vec3 n;\n  vec3 v;\n};\n\nconst float M_PI = 3.141592653589793;\nconst float c_MinRoughness = 0.04;\n\nvec4 SRGBtoLINEAR(vec4 srgbIn)\n{\n#ifdef MANUAL_SRGB\n#ifdef SRGB_FAST_APPROXIMATION\n  vec3 linOut = pow(srgbIn.xyz,vec3(2.2));\n#else\n  vec3 bLess = step(vec3(0.04045),srgbIn.xyz);\n  vec3 linOut = mix( srgbIn.xyz/vec3(12.92), pow((srgbIn.xyz+vec3(0.055))/vec3(1.055),vec3(2.4)), bLess );\n#endif\n  return vec4(linOut,srgbIn.w);;\n#else\n  return srgbIn;\n#endif\n}\n\nvec3 getNormal()\n{\n#ifndef HAS_TANGENTS\n  vec3 pos_dx = dFdx(pbr_vPosition);\n  vec3 pos_dy = dFdy(pbr_vPosition);\n  vec3 tex_dx = dFdx(vec3(pbr_vUV, 0.0));\n  vec3 tex_dy = dFdy(vec3(pbr_vUV, 0.0));\n  vec3 t = (tex_dy.t * pos_dx - tex_dx.t * pos_dy) / (tex_dx.s * tex_dy.t - tex_dy.s * tex_dx.t);\n\n#ifdef HAS_NORMALS\n  vec3 ng = normalize(pbr_vNormal);\n#else\n  vec3 ng = cross(pos_dx, pos_dy);\n#endif\n\n  t = normalize(t - ng * dot(ng, t));\n  vec3 b = normalize(cross(ng, t));\n  mat3 tbn = mat3(t, b, ng);\n#else\n  mat3 tbn = pbr_vTBN;\n#endif\n\n#ifdef HAS_NORMALMAP\n  vec3 n = texture2D(u_NormalSampler, pbr_vUV).rgb;\n  n = normalize(tbn * ((2.0 * n - 1.0) * vec3(u_NormalScale, u_NormalScale, 1.0)));\n#else\n  vec3 n = normalize(tbn[2].xyz);\n#endif\n\n  return n;\n}\n\n\n#ifdef USE_IBL\nvec3 getIBLContribution(PBRInfo pbrInputs, vec3 n, vec3 reflection)\n{\n  float mipCount = 9.0;\n  float lod = (pbrInputs.perceptualRoughness * mipCount);\n  vec3 brdf = SRGBtoLINEAR(texture2D(u_brdfLUT,\n    vec2(pbrInputs.NdotV, 1.0 - pbrInputs.perceptualRoughness))).rgb;\n  vec3 diffuseLight = SRGBtoLINEAR(textureCube(u_DiffuseEnvSampler, n)).rgb;\n\n#ifdef USE_TEX_LOD\n  vec3 specularLight = SRGBtoLINEAR(textureCubeLodEXT(u_SpecularEnvSampler, reflection, lod)).rgb;\n#else\n  vec3 specularLight = SRGBtoLINEAR(textureCube(u_SpecularEnvSampler, reflection)).rgb;\n#endif\n\n  vec3 diffuse = diffuseLight * pbrInputs.diffuseColor;\n  vec3 specular = specularLight * (pbrInputs.specularColor * brdf.x + brdf.y);\n  diffuse *= u_ScaleIBLAmbient.x;\n  specular *= u_ScaleIBLAmbient.y;\n\n  return diffuse + specular;\n}\n#endif\n\n\nvec3 diffuse(PBRInfo pbrInputs)\n{\n  return pbrInputs.diffuseColor / M_PI;\n}\n\nvec3 specularReflection(PBRInfo pbrInputs)\n{\n  return pbrInputs.reflectance0 +\n    (pbrInputs.reflectance90 - pbrInputs.reflectance0) *\n    pow(clamp(1.0 - pbrInputs.VdotH, 0.0, 1.0), 5.0);\n}\n\n\n\nfloat geometricOcclusion(PBRInfo pbrInputs)\n{\n  float NdotL = pbrInputs.NdotL;\n  float NdotV = pbrInputs.NdotV;\n  float r = pbrInputs.alphaRoughness;\n\n  float attenuationL = 2.0 * NdotL / (NdotL + sqrt(r * r + (1.0 - r * r) * (NdotL * NdotL)));\n  float attenuationV = 2.0 * NdotV / (NdotV + sqrt(r * r + (1.0 - r * r) * (NdotV * NdotV)));\n  return attenuationL * attenuationV;\n}\n\n\n\n\n\nfloat microfacetDistribution(PBRInfo pbrInputs)\n{\n  float roughnessSq = pbrInputs.alphaRoughness * pbrInputs.alphaRoughness;\n  float f = (pbrInputs.NdotH * roughnessSq - pbrInputs.NdotH) * pbrInputs.NdotH + 1.0;\n  return roughnessSq / (M_PI * f * f);\n}\n\nvoid PBRInfo_setAmbientLight(inout PBRInfo pbrInputs) {\n  pbrInputs.NdotL = 1.0;\n  pbrInputs.NdotH = 0.0;\n  pbrInputs.LdotH = 0.0;\n  pbrInputs.VdotH = 1.0;\n}\n\nvoid PBRInfo_setDirectionalLight(inout PBRInfo pbrInputs, vec3 lightDirection) {\n  vec3 n = pbrInputs.n;\n  vec3 v = pbrInputs.v;\n  vec3 l = normalize(lightDirection);\n  vec3 h = normalize(l+v);\n\n  pbrInputs.NdotL = clamp(dot(n, l), 0.001, 1.0);\n  pbrInputs.NdotH = clamp(dot(n, h), 0.0, 1.0);\n  pbrInputs.LdotH = clamp(dot(l, h), 0.0, 1.0);\n  pbrInputs.VdotH = clamp(dot(v, h), 0.0, 1.0);\n}\n\nvoid PBRInfo_setPointLight(inout PBRInfo pbrInputs, PointLight pointLight) {\n  vec3 light_direction = normalize(pointLight.position - pbr_vPosition);\n  PBRInfo_setDirectionalLight(pbrInputs, light_direction);\n}\n\nvec3 calculateFinalColor(PBRInfo pbrInputs, vec3 lightColor) {\n  vec3 F = specularReflection(pbrInputs);\n  float G = geometricOcclusion(pbrInputs);\n  float D = microfacetDistribution(pbrInputs);\n  vec3 diffuseContrib = (1.0 - F) * diffuse(pbrInputs);\n  vec3 specContrib = F * G * D / (4.0 * pbrInputs.NdotL * pbrInputs.NdotV);\n  return pbrInputs.NdotL * lightColor * (diffuseContrib + specContrib);\n}\n\nvec4 pbr_filterColor(vec4 colorUnused)\n{\n\n\n  float perceptualRoughness = u_MetallicRoughnessValues.y;\n  float metallic = u_MetallicRoughnessValues.x;\n#ifdef HAS_METALROUGHNESSMAP\n\n  vec4 mrSample = texture2D(u_MetallicRoughnessSampler, pbr_vUV);\n  perceptualRoughness = mrSample.g * perceptualRoughness;\n  metallic = mrSample.b * metallic;\n#endif\n  perceptualRoughness = clamp(perceptualRoughness, c_MinRoughness, 1.0);\n  metallic = clamp(metallic, 0.0, 1.0);\n\n  float alphaRoughness = perceptualRoughness * perceptualRoughness;\n#ifdef HAS_BASECOLORMAP\n  vec4 baseColor = SRGBtoLINEAR(texture2D(u_BaseColorSampler, pbr_vUV)) * u_BaseColorFactor;\n#else\n  vec4 baseColor = u_BaseColorFactor;\n#endif\n\n#ifdef ALPHA_CUTOFF\n  if (baseColor.a < u_AlphaCutoff) {\n    discard;\n  }\n#endif\n\n  vec3 f0 = vec3(0.04);\n  vec3 diffuseColor = baseColor.rgb * (vec3(1.0) - f0);\n  diffuseColor *= 1.0 - metallic;\n  vec3 specularColor = mix(f0, baseColor.rgb, metallic);\n  float reflectance = max(max(specularColor.r, specularColor.g), specularColor.b);\n\n\n\n  float reflectance90 = clamp(reflectance * 25.0, 0.0, 1.0);\n  vec3 specularEnvironmentR0 = specularColor.rgb;\n  vec3 specularEnvironmentR90 = vec3(1.0, 1.0, 1.0) * reflectance90;\n\n  vec3 n = getNormal();\n  vec3 v = normalize(u_Camera - pbr_vPosition);\n\n  float NdotV = clamp(abs(dot(n, v)), 0.001, 1.0);\n  vec3 reflection = -normalize(reflect(v, n));\n\n  PBRInfo pbrInputs = PBRInfo(\n    0.0,\n    NdotV,\n    0.0,\n    0.0,\n    0.0,\n    perceptualRoughness,\n    metallic,\n    specularEnvironmentR0,\n    specularEnvironmentR90,\n    alphaRoughness,\n    diffuseColor,\n    specularColor,\n    n,\n    v\n  );\n\n  vec3 color = vec3(0, 0, 0);\n\n#ifdef USE_LIGHTS\n  PBRInfo_setAmbientLight(pbrInputs);\n  color += calculateFinalColor(pbrInputs, lighting_uAmbientLight.color);\n  SMART_FOR(int i = 0, i < MAX_LIGHTS, i < lighting_uDirectionalLightCount, i++) {\n    if (i < lighting_uDirectionalLightCount) {\n      PBRInfo_setDirectionalLight(pbrInputs, lighting_uDirectionalLight[i].direction);\n      color += calculateFinalColor(pbrInputs, lighting_uDirectionalLight[i].color);\n    }\n  }\n  SMART_FOR(int i = 0, i < MAX_LIGHTS, i < lighting_uPointLightCount, i++) {\n    if (i < lighting_uPointLightCount) {\n      PBRInfo_setPointLight(pbrInputs, lighting_uPointLight[i]);\n      float attenuation = getPointLightAttenuation(lighting_uPointLight[i], distance(lighting_uPointLight[i].position, pbr_vPosition));\n      color += calculateFinalColor(pbrInputs, lighting_uPointLight[i].color / attenuation);\n    }\n  }\n#endif\n#ifdef USE_IBL\n  color += getIBLContribution(pbrInputs, n, reflection);\n#endif\n#ifdef HAS_OCCLUSIONMAP\n  float ao = texture2D(u_OcclusionSampler, pbr_vUV).r;\n  color = mix(color, color * ao, u_OcclusionStrength);\n#endif\n\n#ifdef HAS_EMISSIVEMAP\n  vec3 emissive = SRGBtoLINEAR(texture2D(u_EmissiveSampler, pbr_vUV)).rgb * u_EmissiveFactor;\n  color += emissive;\n#endif\n\n#ifdef PBR_DEBUG\n\n\n\n\n\n  color = mix(color, baseColor.rgb, u_ScaleDiffBaseMR.y);\n  color = mix(color, vec3(metallic), u_ScaleDiffBaseMR.z);\n  color = mix(color, vec3(perceptualRoughness), u_ScaleDiffBaseMR.w);\n#endif\n\n  return vec4(pow(color,vec3(1.0/2.2)), baseColor.a);\n}\n";
exports["default"] = _default;
//# sourceMappingURL=pbr-fragment.glsl.js.map