import ShaderModule from './shader-module';
import { assert } from '../utils';
export function resolveModules(modules) {
  return getShaderDependencies(instantiateModules(modules));
}

function getShaderDependencies(modules) {
  var moduleMap = {};
  var moduleDepth = {};
  getDependencyGraph({
    modules: modules,
    level: 0,
    moduleMap: moduleMap,
    moduleDepth: moduleDepth
  });
  return Object.keys(moduleDepth).sort(function (a, b) {
    return moduleDepth[b] - moduleDepth[a];
  }).map(function (name) {
    return moduleMap[name];
  });
}

function getDependencyGraph(_ref) {
  var modules = _ref.modules,
      level = _ref.level,
      moduleMap = _ref.moduleMap,
      moduleDepth = _ref.moduleDepth;

  if (level >= 5) {
    throw new Error('Possible loop in shader dependency graph');
  }

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = modules[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var module = _step.value;
      moduleMap[module.name] = module;

      if (moduleDepth[module.name] === undefined || moduleDepth[module.name] < level) {
        moduleDepth[module.name] = level;
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = modules[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var _module = _step2.value;

      if (_module.dependencies) {
        getDependencyGraph({
          modules: _module.dependencies,
          level: level + 1,
          moduleMap: moduleMap,
          moduleDepth: moduleDepth
        });
      }
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
        _iterator2["return"]();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }
}

function instantiateModules(modules, seen) {
  return modules.map(function (module) {
    if (module instanceof ShaderModule) {
      return module;
    }

    assert(typeof module !== 'string', "Shader module use by name is deprecated. Import shader module '".concat(module, "' and use it directly."));
    assert(module.name, 'shader module has no name');
    module = new ShaderModule(module);
    module.dependencies = instantiateModules(module.dependencies);
    return module;
  });
}

export var TEST_EXPORTS = {
  getShaderDependencies: getShaderDependencies,
  getDependencyGraph: getDependencyGraph
};
//# sourceMappingURL=resolve-modules.js.map