"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseUniformName = parseUniformName;
exports.getUniformSetter = getUniformSetter;
exports.checkUniformValues = checkUniformValues;
exports.copyUniform = copyUniform;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _gltools = require("@luma.gl/gltools");

var _framebuffer = _interopRequireDefault(require("./framebuffer"));

var _renderbuffer = _interopRequireDefault(require("./renderbuffer"));

var _texture = _interopRequireDefault(require("./texture"));

var _utils = require("../utils");

var _UNIFORM_SETTERS;

var UNIFORM_SETTERS = (_UNIFORM_SETTERS = {}, (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 5126, getArraySetter.bind(null, 'uniform1fv', toFloatArray, 1, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35664, getArraySetter.bind(null, 'uniform2fv', toFloatArray, 2, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35665, getArraySetter.bind(null, 'uniform3fv', toFloatArray, 3, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35666, getArraySetter.bind(null, 'uniform4fv', toFloatArray, 4, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 5124, getArraySetter.bind(null, 'uniform1iv', toIntArray, 1, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35667, getArraySetter.bind(null, 'uniform2iv', toIntArray, 2, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35668, getArraySetter.bind(null, 'uniform3iv', toIntArray, 3, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35669, getArraySetter.bind(null, 'uniform4iv', toIntArray, 4, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35670, getArraySetter.bind(null, 'uniform1iv', toIntArray, 1, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35671, getArraySetter.bind(null, 'uniform2iv', toIntArray, 2, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35672, getArraySetter.bind(null, 'uniform3iv', toIntArray, 3, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35673, getArraySetter.bind(null, 'uniform4iv', toIntArray, 4, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35674, getArraySetter.bind(null, 'uniformMatrix2fv', toFloatArray, 4, setMatrixUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35675, getArraySetter.bind(null, 'uniformMatrix3fv', toFloatArray, 9, setMatrixUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35676, getArraySetter.bind(null, 'uniformMatrix4fv', toFloatArray, 16, setMatrixUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35678, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35680, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 5125, getArraySetter.bind(null, 'uniform1uiv', toUIntArray, 1, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36294, getArraySetter.bind(null, 'uniform2uiv', toUIntArray, 2, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36295, getArraySetter.bind(null, 'uniform3uiv', toUIntArray, 3, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36296, getArraySetter.bind(null, 'uniform4uiv', toUIntArray, 4, setVectorUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35685, getArraySetter.bind(null, 'uniformMatrix2x3fv', toFloatArray, 6, setMatrixUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35686, getArraySetter.bind(null, 'uniformMatrix2x4fv', toFloatArray, 8, setMatrixUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35687, getArraySetter.bind(null, 'uniformMatrix3x2fv', toFloatArray, 6, setMatrixUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35688, getArraySetter.bind(null, 'uniformMatrix3x4fv', toFloatArray, 12, setMatrixUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35689, getArraySetter.bind(null, 'uniformMatrix4x2fv', toFloatArray, 8, setMatrixUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35690, getArraySetter.bind(null, 'uniformMatrix4x3fv', toFloatArray, 12, setMatrixUniform)), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35679, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 35682, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36289, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36292, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36293, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36298, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36299, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36300, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36303, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36306, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36307, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36308, getSamplerSetter), (0, _defineProperty2["default"])(_UNIFORM_SETTERS, 36311, getSamplerSetter), _UNIFORM_SETTERS);
var FLOAT_ARRAY = {};
var INT_ARRAY = {};
var UINT_ARRAY = {};
var array1 = [0];

function toTypedArray(value, uniformLength, Type, cache) {
  if (uniformLength === 1 && typeof value === 'boolean') {
    value = value ? 1 : 0;
  }

  if (Number.isFinite(value)) {
    array1[0] = value;
    value = array1;
  }

  var length = value.length;

  if (length % uniformLength) {
    _gltools.log.warn("Uniform size should be multiples of ".concat(uniformLength), value)();
  }

  if (value instanceof Type) {
    return value;
  }

  var result = cache[length];

  if (!result) {
    result = new Type(length);
    cache[length] = result;
  }

  for (var i = 0; i < length; i++) {
    result[i] = value[i];
  }

  return result;
}

function toFloatArray(value, uniformLength) {
  return toTypedArray(value, uniformLength, Float32Array, FLOAT_ARRAY);
}

function toIntArray(value, uniformLength) {
  return toTypedArray(value, uniformLength, Int32Array, INT_ARRAY);
}

function toUIntArray(value, uniformLength) {
  return toTypedArray(value, uniformLength, Uint32Array, UINT_ARRAY);
}

function parseUniformName(name) {
  if (name[name.length - 1] !== ']') {
    return {
      name: name,
      length: 1,
      isArray: false
    };
  }

  var UNIFORM_NAME_REGEXP = /([^[]*)(\[[0-9]+\])?/;
  var matches = name.match(UNIFORM_NAME_REGEXP);

  if (!matches || matches.length < 2) {
    throw new Error("Failed to parse GLSL uniform name ".concat(name));
  }

  return {
    name: matches[1],
    length: matches[2] || 1,
    isArray: Boolean(matches[2])
  };
}

function getUniformSetter(gl, location, info) {
  var setter = UNIFORM_SETTERS[info.type];

  if (!setter) {
    throw new Error("Unknown GLSL uniform type ".concat(info.type));
  }

  return setter().bind(null, gl, location);
}

function checkUniformValues(uniforms, source, uniformMap) {
  for (var uniformName in uniforms) {
    var value = uniforms[uniformName];
    var shouldCheck = !uniformMap || Boolean(uniformMap[uniformName]);

    if (shouldCheck && !checkUniformValue(value)) {
      source = source ? "".concat(source, " ") : '';
      console.error("".concat(source, " Bad uniform ").concat(uniformName), value);
      throw new Error("".concat(source, " Bad uniform ").concat(uniformName));
    }
  }

  return true;
}

function checkUniformValue(value) {
  if (Array.isArray(value) || ArrayBuffer.isView(value)) {
    return checkUniformArray(value);
  }

  if (isFinite(value)) {
    return true;
  } else if (value === true || value === false) {
    return true;
  } else if (value instanceof _texture["default"]) {
    return true;
  } else if (value instanceof _renderbuffer["default"]) {
    return true;
  } else if (value instanceof _framebuffer["default"]) {
    return Boolean(value.texture);
  }

  return false;
}

function checkUniformArray(value) {
  if (value.length === 0) {
    return false;
  }

  var checkLength = Math.min(value.length, 16);

  for (var i = 0; i < checkLength; ++i) {
    if (!Number.isFinite(value[i])) {
      return false;
    }
  }

  return true;
}

function copyUniform(uniforms, key, value) {
  if (Array.isArray(value) || ArrayBuffer.isView(value)) {
    if (uniforms[key]) {
      var dest = uniforms[key];

      for (var i = 0, len = value.length; i < len; ++i) {
        dest[i] = value[i];
      }
    } else {
      uniforms[key] = value.slice();
    }
  } else {
    uniforms[key] = value;
  }
}

function getSamplerSetter() {
  var cache = null;
  return function (gl, location, value) {
    var update = cache !== value;

    if (update) {
      gl.uniform1i(location, value);
      cache = value;
    }

    return update;
  };
}

function getArraySetter(functionName, toArray, size, uniformSetter) {
  var cache = null;
  var cacheLength = null;
  return function (gl, location, value) {
    var arrayValue = toArray(value, size);
    var length = arrayValue.length;
    var update = false;

    if (cache === null) {
      cache = new Float32Array(length);
      cacheLength = length;
      update = true;
    } else {
      (0, _utils.assert)(cacheLength === length, 'Uniform length cannot change.');

      for (var i = 0; i < length; ++i) {
        if (arrayValue[i] !== cache[i]) {
          update = true;
          break;
        }
      }
    }

    if (update) {
      uniformSetter(gl, functionName, location, arrayValue);
      cache.set(arrayValue);
    }

    return update;
  };
}

function setVectorUniform(gl, functionName, location, value) {
  gl[functionName](location, value);
}

function setMatrixUniform(gl, functionName, location, value) {
  gl[functionName](location, false, value);
}
//# sourceMappingURL=uniforms.js.map