"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.lumaStats = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _gltools = require("@luma.gl/gltools");

var _probe = require("probe.gl");

var _env = require("probe.gl/env");

var VERSION = typeof "8.2.0" !== 'undefined' ? "8.2.0" : 'untranspiled source';
var STARTUP_MESSAGE = 'set luma.log.level=1 (or higher) to trace rendering';

var StatsManager = function () {
  function StatsManager() {
    (0, _classCallCheck2["default"])(this, StatsManager);
    this.stats = new Map();
  }

  (0, _createClass2["default"])(StatsManager, [{
    key: "get",
    value: function get(name) {
      if (!this.stats.has(name)) {
        this.stats.set(name, new _probe.Stats({
          id: name
        }));
      }

      return this.stats.get(name);
    }
  }]);
  return StatsManager;
}();

var lumaStats = new StatsManager();
exports.lumaStats = lumaStats;

if (_env.global.luma && _env.global.luma.VERSION !== VERSION) {
  throw new Error("luma.gl - multiple VERSIONs detected: ".concat(_env.global.luma.VERSION, " vs ").concat(VERSION));
}

if (!_env.global.luma) {
  if ((0, _env.isBrowser)()) {
    _gltools.log.log(1, "luma.gl ".concat(VERSION, " - ").concat(STARTUP_MESSAGE))();
  }

  _env.global.luma = _env.global.luma || {
    VERSION: VERSION,
    version: VERSION,
    log: _gltools.log,
    stats: lumaStats,
    globals: {
      modules: {},
      nodeIO: {}
    }
  };
}

var _default = _env.global.luma;
exports["default"] = _default;
//# sourceMappingURL=init.js.map