"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stubRemovedMethods = stubRemovedMethods;

var _gltools = require("@luma.gl/gltools");

function stubRemovedMethods(instance, className, version, methodNames) {
  var upgradeMessage = "See luma.gl ".concat(version, " Upgrade Guide at https://luma.gl/docs/upgrade-guide");
  var prototype = Object.getPrototypeOf(instance);
  methodNames.forEach(function (methodName) {
    if (prototype.methodName) {
      return;
    }

    prototype[methodName] = function () {
      _gltools.log.removed("Calling removed method ".concat(className, ".").concat(methodName, ": "), upgradeMessage)();

      throw new Error(methodName);
    };
  });
}
//# sourceMappingURL=stub-methods.js.map