import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import Buffer from '../classes/buffer';
import { getKey } from '../webgl-utils';
import { getCompositeGLType } from '../webgl-utils/attribute-utils';
import { formatValue } from '../utils';
export function getDebugTableForVertexArray() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      vertexArray = _ref.vertexArray,
      _ref$header = _ref.header,
      header = _ref$header === void 0 ? 'Attributes' : _ref$header;

  if (!vertexArray.configuration) {
    return {};
  }

  var table = {};

  if (vertexArray.elements) {
    table.ELEMENT_ARRAY_BUFFER = getDebugTableRow(vertexArray, vertexArray.elements, null, header);
  }

  var attributes = vertexArray.values;

  for (var attributeLocation in attributes) {
    var info = vertexArray._getAttributeInfo(attributeLocation);

    if (info) {
      var rowHeader = "".concat(attributeLocation, ": ").concat(info.name);
      var accessor = vertexArray.accessors[info.location];

      if (accessor) {
        rowHeader = "".concat(attributeLocation, ": ").concat(getGLSLDeclaration(info.name, accessor));
      }

      table[rowHeader] = getDebugTableRow(vertexArray, attributes[attributeLocation], accessor, header);
    }
  }

  return table;
}

function getDebugTableRow(vertexArray, attribute, accessor, header) {
  var _ref4;

  var gl = vertexArray.gl;

  if (!attribute) {
    var _ref2;

    return _ref2 = {}, _defineProperty(_ref2, header, 'null'), _defineProperty(_ref2, 'Format ', 'N/A'), _ref2;
  }

  var type = 'NOT PROVIDED';
  var size = 'N/A';
  var verts = 'N/A';
  var bytes = 'N/A';
  var isInteger;
  var marker;
  var value;

  if (accessor) {
    type = accessor.type;
    size = accessor.size;
    type = String(type).replace('Array', '');
    isInteger = type.indexOf('nt') !== -1;
  }

  if (attribute instanceof Buffer) {
    var _ref3;

    var buffer = attribute;

    var _buffer$getDebugData = buffer.getDebugData(),
        data = _buffer$getDebugData.data,
        modified = _buffer$getDebugData.modified;

    marker = modified ? '*' : '';
    value = data;
    bytes = buffer.byteLength;
    verts = bytes / data.BYTES_PER_ELEMENT / size;
    var format;

    if (accessor) {
      var instanced = accessor.divisor > 0;
      format = "".concat(instanced ? 'I ' : 'P ', " ").concat(verts, " (x").concat(size, "=").concat(bytes, " bytes ").concat(getKey(gl, type), ")");
    } else {
      isInteger = true;
      format = "".concat(bytes, " bytes");
    }

    return _ref3 = {}, _defineProperty(_ref3, header, "".concat(marker).concat(formatValue(value, {
      size: size,
      isInteger: isInteger
    }))), _defineProperty(_ref3, 'Format ', format), _ref3;
  }

  value = attribute;
  size = attribute.length;
  type = String(attribute.constructor.name).replace('Array', '');
  isInteger = type.indexOf('nt') !== -1;
  return _ref4 = {}, _defineProperty(_ref4, header, "".concat(formatValue(value, {
    size: size,
    isInteger: isInteger
  }), " (constant)")), _defineProperty(_ref4, 'Format ', "".concat(size, "x").concat(type, " (constant)")), _ref4;
}

function getGLSLDeclaration(name, accessor) {
  var type = accessor.type,
      size = accessor.size;
  var typeAndName = getCompositeGLType(type, size);
  return typeAndName ? "".concat(name, " (").concat(typeAndName.name, ")") : name;
}
//# sourceMappingURL=debug-vertex-array.js.map