"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
const DeclarationReference_1 = require("@microsoft/tsdoc/lib/beta/DeclarationReference");
const ApiDeclaredItem_1 = require("../items/ApiDeclaredItem");
const ApiReleaseTagMixin_1 = require("../mixins/ApiReleaseTagMixin");
const ApiItemContainerMixin_1 = require("../mixins/ApiItemContainerMixin");
const ApiNameMixin_1 = require("../mixins/ApiNameMixin");
/**
 * Represents a TypeScript enum declaration.
 *
 * @remarks
 *
 * This is part of the {@link ApiModel} hierarchy of classes, which are serializable representations of
 * API declarations.
 *
 * `ApiEnum` represents an enum declaration such as `FontSizes` in the example below:
 *
 * ```ts
 * export enum FontSizes {
 *   Small = 100,
 *   Medium = 200,
 *   Large = 300
 * }
 * ```
 *
 * @public
 */
class ApiEnum extends ApiItemContainerMixin_1.ApiItemContainerMixin(ApiNameMixin_1.ApiNameMixin(ApiReleaseTagMixin_1.ApiReleaseTagMixin(ApiDeclaredItem_1.ApiDeclaredItem))) {
    constructor(options) {
        super(options);
    }
    static getContainerKey(name) {
        return `${name}|${"Enum" /* Enum */}`;
    }
    /** @override */
    get kind() {
        return "Enum" /* Enum */;
    }
    /** @override */
    get members() {
        return super.members;
    }
    /** @override */
    get containerKey() {
        return ApiEnum.getContainerKey(this.name);
    }
    /** @override */
    addMember(member) {
        if (member.kind !== "EnumMember" /* EnumMember */) {
            throw new Error('Only ApiEnumMember objects can be added to an ApiEnum');
        }
        super.addMember(member);
    }
    /** @beta @override */
    buildCanonicalReference() {
        const nameComponent = DeclarationReference_1.DeclarationReference.parseComponent(this.name);
        return (this.parent ? this.parent.canonicalReference : DeclarationReference_1.DeclarationReference.empty())
            .addNavigationStep("." /* Exports */, nameComponent)
            .withMeaning("enum" /* Enum */);
    }
}
exports.ApiEnum = ApiEnum;
//# sourceMappingURL=ApiEnum.js.map