"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
const DeclarationReference_1 = require("@microsoft/tsdoc/lib/beta/DeclarationReference");
const ApiItemContainerMixin_1 = require("../mixins/ApiItemContainerMixin");
const ApiDeclaredItem_1 = require("../items/ApiDeclaredItem");
const ApiReleaseTagMixin_1 = require("../mixins/ApiReleaseTagMixin");
const ApiNameMixin_1 = require("../mixins/ApiNameMixin");
/**
 * Represents a TypeScript namespace declaration.
 *
 * @remarks
 *
 * This is part of the {@link ApiModel} hierarchy of classes, which are serializable representations of
 * API declarations.
 *
 * `ApiNamespace` represents a TypeScript declaration such `X` or `Y` in this example:
 *
 * ```ts
 * export namespace X {
 *   export namespace Y {
 *     export interface IWidget {
 *       render(): void;
 *     }
 *   }
 * }
 * ```
 *
 * @public
 */
class ApiNamespace extends ApiItemContainerMixin_1.ApiItemContainerMixin(ApiNameMixin_1.ApiNameMixin(ApiReleaseTagMixin_1.ApiReleaseTagMixin(ApiDeclaredItem_1.ApiDeclaredItem))) {
    constructor(options) {
        super(options);
    }
    static getContainerKey(name) {
        return `${name}|${"Namespace" /* Namespace */}`;
    }
    /** @override */
    get kind() {
        return "Namespace" /* Namespace */;
    }
    /** @override */
    get containerKey() {
        return ApiNamespace.getContainerKey(this.name);
    }
    /** @beta @override */
    buildCanonicalReference() {
        const nameComponent = DeclarationReference_1.DeclarationReference.parseComponent(this.name);
        return (this.parent ? this.parent.canonicalReference : DeclarationReference_1.DeclarationReference.empty())
            .addNavigationStep("." /* Exports */, nameComponent)
            .withMeaning("namespace" /* Namespace */);
    }
}
exports.ApiNamespace = ApiNamespace;
//# sourceMappingURL=ApiNamespace.js.map