"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Helpers for working with the ts-command-line API.
 *
 * @public
 */
class CommandLineHelper {
    /**
     * Returns true if the current command line action is tab-complete.
     *
     * @public
     */
    static isTabCompletionActionRequest(argv) {
        return argv && argv.length > 2 && argv[2] === "tab-complete" /* TabCompletionActionName */;
    }
}
exports.CommandLineHelper = CommandLineHelper;
//# sourceMappingURL=CommandLineHelper.js.map